---
generated_at: 2026-02-10 12:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：122-テスト準備

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張がソースコードで裏付けられている
  2. Helix連携の詳細は運用ドキュメントで確認推奨
  3. TestDiscoveryWorkerの詳細実装は別途確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Tools/PrepareTests/Program.cs`
- E-02: `src/Tools/PrepareTests/TestDiscovery.cs`
- E-03: `src/Tools/PrepareTests/MinimizeUtil.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Mono.Optionsで引数解析を行う | E-01 (22-28行目) | ○ |
| C-02 | --source引数は必須 | E-01 (31-35行目) | ○ |
| C-03 | --destination引数は必須 | E-01 (37-41行目) | ○ |
| C-04 | dotnetPathはデフォルト"dotnet" | E-01 (43-46行目) | ○ |
| C-05 | TestDiscovery.RunDiscoveryを呼び出す | E-01 (48行目) | ○ |
| C-06 | MinimizeUtil.Runを呼び出す | E-01 (54行目) | ○ |
| C-07 | *UnitTests.dllと*IntegrationTests.dllを検出 | E-02 (107-109行目) | ○ |
| C-08 | Unix環境ではnet472を除外 | E-02 (114-122行目) | ○ |
| C-09 | 並列処理でテストディスカバリを実行 | E-02 (31行目) | ○ |
| C-10 | testlist.jsonを各アセンブリディレクトリに出力 | E-02 (88行目) | ○ |
| C-11 | .duplicateディレクトリに重複ファイルを格納 | E-03 (27行目) | ○ |
| C-12 | global.jsonとNuGet.configをコピー | E-03 (30-41行目) | ○ |
| C-13 | PEファイルからMVIDを取得 | E-03 (343-364行目) | ○ |
| C-14 | ハードリンクで重複を解決 | E-03 (128行目, 314-341行目) | ○ |
| C-15 | Windows用CreateHardLinkを使用 | E-03 (335-336行目) | ○ |
| C-16 | Unix用link関数を使用 | E-03 (339-340行目) | ○ |
| C-17 | rehydrate.cmd/shスクリプトを生成 | E-03 (164行目) | ○ |
| C-18 | HELIX_CORRELATION_PAYLOAD環境変数を使用 | E-03 (156-161行目) | ○ |
| C-19 | Unix環境で実行権限を保持 | E-03 (104-111行目, 267-273行目) | ○ |
| C-20 | 終了コード0(成功)/1(失敗)を返す | E-01 (12-13行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張がソースコードで裏付けられているため、不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで裏付けられている
- TestDiscoveryWorkerの詳細実装は別ディレクトリにあるため、必要に応じて確認

## 6) レビュアーチェックリスト（最小）
- [ ] コマンドライン引数の解析がソースコードと一致しているか
- [ ] TestDiscovery処理フローが正確に記述されているか
- [ ] MinimizeUtil処理フローが正確に記述されているか
- [ ] ハードリンク作成のOS別処理が正確か
- [ ] Helix連携に関する記述を運用チームと確認
