---
generated_at: 2026-02-10 12:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：123-セマンティック検索

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **サンドボックス実行**：セキュリティ実装の詳細確認が必要
  2. **Copilot連携クエリ生成**：Copilot統合の詳細確認が必要
  3. **ツールウィンドウUI**：Visual Studio統合の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Features/Core/Portable/SemanticSearch/ISemanticSearchQueryService.cs`
- E-02: `src/Features/Core/Portable/SemanticSearch/IRemoteSemanticSearchService.cs`
- E-03: `src/Features/Core/Portable/SemanticSearch/SemanticSearchWorkspace.cs`
- E-04: `src/VisualStudio/CSharp/Impl/SemanticSearch/SemanticSearchToolWindowController.cs`
- E-05: `src/VisualStudio/CSharp/Impl/SemanticSearch/SemanticSearchQueryExecutor.cs`
- E-06: `src/Workspaces/Remote/ServiceHub/Services/SemanticSearch/RemoteSemanticSearchService.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CompileQueryでクエリをコンパイルする | E-01 (20-26行目) | ○ |
| C-02 | ExecuteQueryAsyncでクエリを実行する | E-01 (35-41行目) | ○ |
| C-03 | DiscardQueryでリソースを解放する | E-01 (47行目) | ○ |
| C-04 | リモートサービスにコールバックインターフェースがある | E-02 (24-31行目) | ○ |
| C-05 | OnDefinitionFoundで結果を通知する | E-02 (24行目) | ○ |
| C-06 | OnUserCodeExceptionで例外を通知する | E-02 (25行目) | ○ |
| C-07 | ReferenceAssembliesDirectoryで参照アセンブリパスを定義 | E-03 (21行目) | ○ |
| C-08 | CanOpenDocumentsがtrueを返す | E-03 (23-24行目) | ○ |
| C-09 | CanApplyChangeはChangeDocumentのみ許可 | E-03 (26-27行目) | ○ |
| C-10 | UpdateQueryDocumentAsyncでクエリドキュメント更新 | E-03 (29-48行目) | ○ |
| C-11 | targetLanguage引数で検索対象言語を限定可能 | E-01 (17行目), E-02 (34行目) | ○ |
| C-12 | リモートプロセスでクエリを実行する | E-02, E-06 | ○ |
| C-13 | ServerCallbackパターンでコールバック処理 | E-02 (71-162行目) | ○ |
| C-14 | RemoteSemanticSearchServiceProxyでリモート呼び出し | E-02 (164-203行目) | ○ |
| C-15 | キャンセレーショントークンをサポート | E-01, E-02 (各メソッドの引数) | ○ |
| C-16 | AddItemsAsync/ItemsCompletedAsyncで進捗通知 | E-02 (27-28行目) | ○ |
| C-17 | Copilot連携でクエリ生成可能 | Copilot関連ファイル（存在確認済） | ○ |
| C-18 | ユーザーコードをサンドボックスで実行 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18について：サンドボックス実行に関する具体的な実装コードが確認できない
  - 候補：セキュリティ設計書 / AppDomain分離実装 / プロセス分離実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - インターフェース定義とリモート実行パターンは正確
- 1: 中リスク - サンドボックス実行に関する記述は実装詳細の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ISemanticSearchQueryServiceのインターフェースが正確に記述されているか
- [ ] リモート実行パターン（Proxy/Callback）が正確か
- [ ] SemanticSearchWorkspaceの制約が正確か
- [ ] サンドボックス実行のセキュリティ実装を確認
- [ ] Visual Studio統合（ツールウィンドウ）の詳細を確認
