---
generated_at: 2026-02-10 13:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：124-Copilot連携

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **GitHub Copilot APIとの連携詳細**：実装詳細の確認が必要
  2. **クォータ管理の具体的仕様**：API仕様の確認が必要
  3. **Smart Rename UI実装**：Visual Studio統合の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Features/Core/Portable/Copilot/ICopilotCodeAnalysisService.cs`
- E-02: `src/Features/Core/Portable/Copilot/CopilotUtilities.cs`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-04: `src/Features/Core/Portable/Copilot/ICopilotOptionsService.cs`
- E-05: `src/Features/Core/Portable/Copilot/ICopilotChangeAnalysisService.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IsAvailableAsyncでCopilot可用性を確認 | E-01 (26行目) | ○ |
| C-02 | GetAvailablePromptTitlesAsyncでプロンプト一覧取得 | E-01 (36行目) | ○ |
| C-03 | AnalyzeDocumentAsyncでドキュメント分析実行 | E-01 (46行目) | ○ |
| C-04 | GetCachedDocumentDiagnosticsAsyncでキャッシュ結果取得 | E-01 (57行目) | ○ |
| C-05 | StartRefinementSessionAsyncでリファインメント開始 | E-01 (65行目) | ○ |
| C-06 | GetOnTheFlyDocsPromptAsyncでプロンプト構築 | E-01 (72行目) | ○ |
| C-07 | GetOnTheFlyDocsResponseAsyncで応答取得 | E-01 (78行目) | ○ |
| C-08 | IsFileExcludedAsyncでファイル除外判定 | E-01 (83行目) | ○ |
| C-09 | GetDocumentationCommentAsyncでコメント生成 | E-01 (89行目) | ○ |
| C-10 | ImplementNotImplementedExceptionsAsyncで実装生成 | E-01 (100-103行目) | ○ |
| C-11 | isQuotaExceededでクォータ超過を通知 | E-01 (78行目, 89行目) | ○ |
| C-12 | GetNewTextAndChangedSpansで変更とSpan計算 | E-02 (19-32行目) | ○ |
| C-13 | GetTextSpansFromTextChangesでSpan計算 | E-02 (34-51行目) | ○ |
| C-14 | TryNormalizeCopilotTextChangesで変更正規化 | E-02 (60-81行目) | ○ |
| C-15 | オーバーラップ変更は正規化失敗でdefault返却 | E-02 (75-76行目) | ○ |
| C-16 | 画面No.21リネームフライアウトが関連画面 | E-03 (28行目) | ○ |
| C-17 | 画面No.24スマートリネームコンボボックスが関連画面 | E-03 (32行目) | ○ |
| C-18 | 画面No.25スマートリネームステータスが関連画面 | E-03 (34行目) | ○ |
| C-19 | 画面No.26オンザフライドキュメントビューが関連画面 | E-03 (36行目) | ○ |
| C-20 | GitHub Copilotサブスクリプションが必要 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20について：サブスクリプション要件はGitHub Copilot側の仕様であり、Roslynコード内には明示されていない
  - 候補：GitHub Copilot公式ドキュメント / Visual Studio Copilot拡張ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - インターフェース定義は正確に記述
- 1: 中リスク - GitHub Copilot API連携の詳細は外部サービス依存

## 6) レビュアーチェックリスト（最小）
- [ ] ICopilotCodeAnalysisServiceのインターフェースが正確に記述されているか
- [ ] CopilotUtilitiesのテキスト変更処理が正確か
- [ ] 関連画面との対応が画面機能マッピングと一致しているか
- [ ] クォータ管理の仕様をGitHub Copilotドキュメントと照合
- [ ] サブスクリプション要件を外部ドキュメントで確認
