---
generated_at: 2026-02-10 13:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：125-シンボル検索

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張がソースコードで裏付けられている
  2. Elfieデータベースの詳細仕様は外部ライブラリドキュメント参照推奨
  3. データベース更新の詳細はUpdate.csで確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Features/Core/Portable/SymbolSearch/Windows/SymbolSearchUpdateEngine.cs`
- E-02: `src/Features/Core/Portable/SymbolSearch/SymbolSearchUpdateNoOpEngine.cs`
- E-03: `src/Features/Core/Portable/SymbolSearch/SymbolSearchOptions.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Elfieデータベースを使用してシンボル検索 | E-01 (27-29行目コメント) | ○ |
| C-02 | _sourceToDatabaseでソース別データベース管理 | E-01 (35行目) | ○ |
| C-03 | FindPackagesAsyncでパッケージ検索 | E-01 (75-95行目) | ○ |
| C-04 | FindReferenceAssembliesAsyncで参照アセンブリ検索 | E-01 (97-112行目) | ○ |
| C-05 | FindPackagesWithAssemblyAsyncでアセンブリ名検索 | E-01 (176-215行目) | ○ |
| C-06 | "var"という名前の検索は結果なし | E-01 (131-132行目) | ○ |
| C-07 | MemberQueryでElfieデータベースにクエリ実行 | E-01 (134行目) | ○ |
| C-08 | PartialArrayで100件を上限に結果取得 | E-01 (135行目) | ○ |
| C-09 | FilterToViableSymbolsで結果フィルタリング | E-01 (140行目, 151-173行目) | ○ |
| C-10 | ネスト型は検索結果から除外 | E-01 (168-169行目) | ○ |
| C-11 | MicrosoftAssemblyReferencesNameで参照アセンブリを区別 | E-01 (81行目, 105行目) | ○ |
| C-12 | GetRankでランキング取得 | E-01 (217-226行目) | ○ |
| C-13 | ランクはPopularityRankから取得 | E-01 (246-247行目) | ○ |
| C-14 | パース失敗時はランク0 | E-01 (219-223行目) | ○ |
| C-15 | Disposeメソッドは何もしない | E-01 (70-73行目) | ○ |
| C-16 | FatalError.ReportAndCatchUnlessCanceledでエラー処理 | E-01 (47行目) | ○ |
| C-17 | SourceBuild環境向けNoOp実装あり | E-02 (存在確認) | ○ |
| C-18 | ConcurrentDictionaryでスレッドセーフに管理 | E-01 (35行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張がソースコードで裏付けられているため、不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードに基づく技術的記述は正確
- Elfieデータベースの詳細仕様は外部依存

## 6) レビュアーチェックリスト（最小）
- [ ] FindPackagesAsync/FindReferenceAssembliesAsyncの処理が正確か
- [ ] フィルタリングロジック（FilterToViableSymbols）が正確か
- [ ] ランキング計算（GetRank）が正確か
- [ ] データベース更新処理（Update.cs）の詳細を確認
- [ ] Elfieデータベースの仕様を外部ドキュメントで確認
