---
generated_at: 2026-02-10 13:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：126-名前空間同期

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張がソースコードで裏付けられている
  2. C#/VB固有実装の詳細は言語別ファイルで確認推奨
  3. 診断アナライザーの詳細はAnalyzersプロジェクトで確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Features/Core/Portable/SyncNamespaces/AbstractSyncNamespacesService.cs`
- E-02: `src/Features/Core/Portable/SyncNamespaces/ISyncNamespacesService.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ジェネリック型パラメータでC#/VB抽象化 | E-01 (22-26行目) | ○ |
| C-02 | DiagnosticAnalyzer抽象プロパティを持つ | E-01 (27行目) | ○ |
| C-03 | IsHostAnalyzer抽象プロパティを持つ | E-01 (28行目) | ○ |
| C-04 | CodeFixProvider抽象プロパティを持つ | E-01 (29行目) | ○ |
| C-05 | SyncNamespacesAsyncがメインメソッド | E-01 (32-56行目) | ○ |
| C-06 | 全プロジェクトが同一言語であることをアサート | E-01 (38行目) | ○ |
| C-07 | GetDiagnosticsByProjectAsyncで診断取得 | E-01 (42行目, 58-73行目) | ○ |
| C-08 | 診断なしの場合は元のソリューションを返却 | E-01 (45-48行目) | ○ |
| C-09 | GetFixAllContextAsyncでFixAllContext構築 | E-01 (50-51行目, 95-134行目) | ○ |
| C-10 | ApplyCodeFixAsyncでFixAll適用 | E-01 (55行目, 136-150行目) | ○ |
| C-11 | GetDiagnosticsAsyncでコンパイル+アナライザー実行 | E-01 (75-93行目) | ○ |
| C-12 | concurrentAnalysis: trueで並列実行 | E-01 (87行目) | ○ |
| C-13 | FixAllScope.Solutionでソリューション全体修正 | E-01 (128行目) | ○ |
| C-14 | DiagnosticProviderネストクラスが存在 | E-01 (152-181行目) | ○ |
| C-15 | FixAllProvider.GetFixAsyncで修正取得 | E-01 (141行目) | ○ |
| C-16 | ApplyChangesOperationで変更適用 | E-01 (144-148行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張がソースコードで裏付けられているため、不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードに基づく技術的記述は正確
- 言語固有実装（C#/VB）は別途確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] SyncNamespacesAsyncのメイン処理フローが正確か
- [ ] GetDiagnosticsByProjectAsyncの診断取得処理が正確か
- [ ] GetFixAllContextAsyncのFixAllContext構築が正確か
- [ ] ApplyCodeFixAsyncの変更適用処理が正確か
- [ ] 言語固有実装（C#/VB）を確認
