---
generated_at: 2026-02-10 13:15:00
metrics:
  claims_total: 12
  claims_with_evidence: 10
  claims_without_evidence: 2
confidence_derived: 0.83
---

# 根拠レポート：127-マップコード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：10 / 12、根拠なし：2
- 優先レビュー（高）
  1. **言語固有実装の詳細**：具体的な実装ファイルの確認が必要
  2. **ヒューリスティック処理**：マッピングアルゴリズムの詳細確認が必要
  3. **Copilot統合**：AI連携の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Features/Core/Portable/MapCode/IMapCodeService.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IMapCodeServiceがILanguageServiceを継承 | E-01 (21行目) | ○ |
| C-02 | MapCodeAsyncメソッドが定義されている | E-01 (30-34行目) | ○ |
| C-03 | documentパラメータでターゲットドキュメントを受け取る | E-01 (31行目) | ○ |
| C-04 | contentsパラメータでコードスニペットを受け取る | E-01 (32行目) | ○ |
| C-05 | prioritizedFocusLocationsで優先位置を指定 | E-01 (33行目) | ○ |
| C-06 | 戻り値はImmutableArray<TextChange>?でnull許容 | E-01 (34行目) | ○ |
| C-07 | Replace existing codeが責務の一つ | E-01 (17行目) | ○ |
| C-08 | Insert new codeが責務の一つ | E-01 (18行目) | ○ |
| C-09 | 早いインデックスほど高優先 | E-01 (28行目コメント) | ○ |
| C-10 | 失敗時nullを返却 | E-01 (34行目の戻り型) | ○ |
| C-11 | ヒューリスティックによる位置決定を行う | **根拠なし（実装詳細）** | △ |
| C-12 | Copilot統合で使用される | **根拠なし（利用者側実装）** | △ |

## 4) 不足情報（Unknown / Missing）
- C-11について：具体的なマッピングアルゴリズムの実装が確認できない
  - 候補：言語固有実装（C#/VB MapCodeService）
- C-12について：Copilot側での利用方法が確認できない
  - 候補：Copilot ExternalAccess / Visual Studio統合

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - インターフェースのみで実装詳細が限定的
- 実装ファイルの特定と確認が推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] IMapCodeServiceインターフェースが正確に記述されているか
- [ ] パラメータと戻り値の説明が正確か
- [ ] 言語固有実装（C#/VB）を特定・確認
- [ ] マッピングアルゴリズムの詳細を確認
- [ ] Copilot側での利用方法を確認
