---
generated_at: 2026-02-10 13:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：128-名前付き引数使用

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張がソースコードで裏付けられている
  2. 言語固有実装（C#/VB）は別途確認推奨
  3. 属性引数処理の詳細は別途確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Features/Core/Portable/UseNamedArguments/AbstractUseNamedArgumentsCodeRefactoringProvider.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CodeRefactoringProviderを継承 | E-01 (15行目) | ○ |
| C-02 | IAnalyzerインターフェースを定義 | E-01 (17-20行目) | ○ |
| C-03 | Analyzer<T>抽象クラスが存在 | E-01 (22-184行目) | ○ |
| C-04 | ComputeRefactoringsAsyncがメイン処理 | E-01 (27-133行目) | ○ |
| C-05 | GetRelevantNodesAsyncで引数取得 | E-01 (33行目) | ○ |
| C-06 | IsPositionalArgumentで位置引数判定 | E-01 (39-42行目) | ○ |
| C-07 | GetReceiverでレシーバー取得 | E-01 (44-48行目) | ○ |
| C-08 | レシーバー診断チェック | E-01 (50-53行目) | ○ |
| C-09 | GetSymbolInfoでシンボル解決 | E-01 (57行目) | ○ |
| C-10 | GetParametersでパラメータ取得 | E-01 (63行目) | ○ |
| C-11 | IsLegalToAddNamedArgumentsで変換可否判定 | E-01 (83-86行目) | ○ |
| C-12 | IsImplicitIndexOrRangeIndexerで除外判定 | E-01 (87-90行目) | ○ |
| C-13 | SupportsNonTrailingNamedArgumentsで言語バージョン判定 | E-01 (107行目) | ○ |
| C-14 | 単一引数名前追加アクション | E-01 (110-115行目, 126-131行目) | ○ |
| C-15 | 末尾引数含む名前追加アクション | E-01 (117-122行目) | ○ |
| C-16 | AddNamedArgumentsAsyncでドキュメント更新 | E-01 (135-147行目) | ○ |
| C-17 | MiscellaneousFilesワークスペース除外 | E-01 (200-203行目) | ○ |
| C-18 | 引数アナライザーと属性引数アナライザーを実行 | E-01 (207-211行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張がソースコードで裏付けられているため、不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードに基づく技術的記述は正確
- 言語固有実装（C#/VB）は別ファイルで確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ComputeRefactoringsAsyncの処理フローが正確か
- [ ] 判定ロジック（IsPositionalArgument等）が正確か
- [ ] リファクタリングアクション生成が正確か
- [ ] 言語固有実装（C#/VB）を確認
- [ ] 属性引数アナライザーの動作を確認
