---
generated_at: 2026-02-10 10:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-基底へ移動

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/GoToBase/IGoToBaseService.cs` - サービスインターフェース定義
- E-02: `src/Features/Core/Portable/GoToBase/AbstractGoToBaseService.cs` - 抽象基底クラス実装
- E-03: `src/Features/Core/Portable/GoToBase/FindBaseHelpers.cs` - ヘルパー関数
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FindBasesAsyncで基底シンボルを検索 | E-01 (12-13行目) | ○ |
| C-02 | セマンティックモデルを取得してシンボル解析 | E-02 (15-16行目) | ○ |
| C-03 | SymbolFinder.FindSymbolAtPositionAsyncでシンボル取得 | E-02 (18行目) | ○ |
| C-04 | FindBaseHelpers.FindBasesAsyncで基底シンボル取得 | E-02 (23行目) | ○ |
| C-05 | symbol.ToNonClassifiedDefinitionItemAsyncでDefinitionItem変換 | E-02 (26行目) | ○ |
| C-06 | 型シンボルの場合は基底型とインターフェースを取得 | E-03 (14-17行目) | ○ |
| C-07 | メソッドシンボルの場合はオーバーライド元と実装を取得 | E-03 (19-22行目) | ○ |
| C-08 | プロパティシンボルの基底取得をサポート | E-03 (24-27行目) | ○ |
| C-09 | イベントシンボルの基底取得をサポート | E-03 (29-32行目) | ○ |
| C-10 | AddBasesAsyncで基底型を追加 | E-03 (39-59行目) | ○ |
| C-11 | System.Object、System.ValueType、Object?を除外 | E-03 (52-53行目) | ○ |
| C-12 | 実装インターフェースをすべて追加 | E-03 (55-56行目) | ○ |
| C-13 | AddOverriddenMemberAsyncでオーバーライド元追加 | E-03 (61-81行目) | ○ |
| C-14 | AddImplementedInterfaceMembersAsyncでインターフェース実装追加 | E-03 (83-106行目) | ○ |
| C-15 | ソース定義をSymbolFinder.FindSourceDefinitionAsyncで検索 | E-03 (69, 93行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり
- 0: 低リスク - シンボル種別ごとの処理が明確

## 6) レビュアーチェックリスト（最小）
- [ ] System.Object除外のロジックが正しく動作するか確認
- [ ] 複数インターフェース実装時の動作を確認
- [ ] ジェネリック型の基底取得が正しく動作するか確認
