---
generated_at: 2026-02-10 12:50:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：132-フレームワーク型優先

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **C#/VB両言語対応の詳細**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/PreferFrameworkType/PreferFrameworkTypeDiagnosticAnalyzerBase.cs`
- E-02: `src/Features/Core/Portable/PreferFrameworkType/PreferFrameworkTypeCodeFixProvider.cs`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 診断ID IDE0049を使用 | E-01 (25行目) | ○ |
| C-02 | SemanticSpanAnalysisカテゴリ | E-01 (37-38行目) | ○ |
| C-03 | RegisterSyntaxNodeActionで登録 | E-01 (45-46行目) | ○ |
| C-04 | 2つのCodeStyleオプションを参照 | E-01 (29-30行目) | ○ |
| C-05 | PredefinedTypeSyntaxとIdentifierNameSyntaxを対象 | E-01 (71-83行目) | ○ |
| C-06 | SpecialType.Noneでない場合のみ処理 | E-01 (86-90行目) | ○ |
| C-07 | IsInMemberAccessOrCrefReferenceContextで判定 | E-01 (94-96行目) | ○ |
| C-08 | IsFrameworkTypePreferredの判定ロジック | E-01 (106-107行目) | ○ |
| C-09 | SyntaxEditorBasedCodeFixProviderを継承 | E-02 (21行目) | ○ |
| C-10 | IntPtr/UIntPtrの特殊処理 | E-02 (51-53行目) | ○ |
| C-11 | generator.TypeExpressionで変換 | E-02 (53行目) | ○ |
| C-12 | IncludeDiagnosticDuringFixAllでフィルタリング | E-02 (59-60行目) | ○ |
| C-13 | 機能カテゴリは「その他」 | E-03 | ○ |
| C-14 | C#とVB両対応 | E-02 (18行目) | ○ |
| C-15 | VB固有の実装詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- VB固有の実装詳細（VB用の派生クラス）
  - 候補：`src/Features/VisualBasic/Portable/PreferFrameworkType/` ディレクトリ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - C#実装については十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] IntPtr/UIntPtrの特殊処理の動作確認
- [ ] VB固有の実装がある場合は追記検討
- [ ] EditorConfig設定例の追加を検討
