---
generated_at: 2026-02-10 12:55:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：133-生文字列リテラル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **Return処理の詳細実装**：ファイル内容未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/RawStringLiteral/IRawStringLiteralOnAutoInsertService.cs`
- E-02: `src/Features/CSharp/Portable/RawStringLiteral/CSharpRawStringLiteralOnAutoInsertService.cs`
- E-03: `src/EditorFeatures/CSharp/RawStringLiteral/RawStringLiteralCommandHandler.cs`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GetTextChangeForQuoteメソッドが入力時変更を計算 | E-01 (21-26行目) | ○ |
| C-02 | 3つのパターンを順次試行 | E-02 (23-26行目) | ○ |
| C-03 | 空文字列から生文字列への変換 | E-02 (33-72行目) | ○ |
| C-04 | デリミタのクォート数は偶数 | E-02 (95-97行目) | ○ |
| C-05 | 最小6クォート（開始3+終了3） | E-02 (103-105行目) | ○ |
| C-06 | トークン種別チェック | E-02 (63-69行目, 115-121行目) | ○ |
| C-07 | TextChange生成（"""追加） | E-02 (71行目) | ○ |
| C-08 | TextChange生成（"追加） | E-02 (123行目) | ○ |
| C-09 | ICommandHandler実装 | E-03 (16行目) | ○ |
| C-10 | ITextUndoHistoryRegistry使用 | E-03 (27行目) | ○ |
| C-11 | IEditorOperationsFactoryService使用 | E-03 (28行目) | ○ |
| C-12 | 補間生文字列（$"""）対応 | E-02 (117-118行目) | ○ |
| C-13 | @""後は処理しない | E-02 (55-56行目) | ○ |
| C-14 | Return処理の詳細実装 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- Return処理（RawStringLiteralCommandHandler_Return.cs）の詳細実装
  - 候補：`src/EditorFeatures/CSharp/RawStringLiteral/RawStringLiteralCommandHandler_Return.cs` を読み込み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理ロジックは確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 3つの変換パターンの境界条件を確認
- [ ] Return処理のインデント計算ロジックを確認
- [ ] 補間生文字列の動作確認
