---
generated_at: 2026-02-10 13:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：134-宣言の移動

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **State.csの詳細実装**：一部未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/MoveDeclarationNearReference/AbstractMoveDeclarationNearReferenceCodeRefactoringProvider.cs`
- E-02: `src/Workspaces/SharedUtilitiesAndExtensions/Workspace/Core/LanguageServices/MoveDeclarationNearReference/AbstractMoveDeclarationNearReferenceService.cs`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CodeRefactoringProviderを継承 | E-01 (14行目) | ○ |
| C-02 | 単一変数のみ対象 | E-01 (24-26行目) | ○ |
| C-03 | CanMoveDeclarationNearReferenceAsyncで判定 | E-01 (29行目) | ○ |
| C-04 | 意味変更時は異なるタイトル | E-01 (33-35行目) | ○ |
| C-05 | CodeActionPriority.Lowで登録 | E-01 (42行目) | ○ |
| C-06 | IMoveDeclarationNearReferenceServiceを使用 | E-01 (28行目, 49行目) | ○ |
| C-07 | ComputeStateAsyncで状態計算 | E-02 (47-75行目) | ○ |
| C-08 | CrossesMeaningfulBlockで意味変更判定 | E-02 (185-202行目) | ○ |
| C-09 | CanMergeDeclarationAndAssignmentAsync | E-02 (204-233行目) | ○ |
| C-10 | MergeDeclarationAndAssignment処理 | E-02 (159-175行目) | ○ |
| C-11 | MoveDeclarationToFirstReferenceAsync処理 | E-02 (118-157行目) | ○ |
| C-12 | SyntaxEditorで編集 | E-02 (85行目) | ○ |
| C-13 | WarningAnnotation使用 | E-02 (88-90行目) | ○ |
| C-14 | Simplifier.ExpandAsync使用 | E-02 (123-124行目) | ○ |
| C-15 | IFileBannerFactsService使用 | E-02 (132行目) | ○ |
| C-16 | State.GenerateAsyncの詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- State.GenerateAsyncの詳細実装（AbstractMoveDeclarationNearReferenceService.State.cs）
  - 候補：該当ファイルを読み込み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理フローは確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] CrossesMeaningfulBlockの判定ロジックを確認
- [ ] 複数変数宣言時の挙動を確認
- [ ] VB固有の実装を確認
