---
generated_at: 2026-02-10 13:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：135-ファイルバナー追加

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **AddFileBannerHelpers.csの詳細実装**：未読み込み

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/AddFileBanner/AbstractAddFileBannerCodeRefactoringProvider.cs`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SyntaxEditorBasedCodeRefactoringProviderを継承 | E-01 (24行目) | ○ |
| C-02 | FixAllスコープはProject, Solution | E-01 (30-31行目) | ○ |
| C-03 | span.IsEmptyチェック | E-01 (36-39行目) | ○ |
| C-04 | FileHeaderTemplate設定時は無効化 | E-01 (41-46行目) | ○ |
| C-05 | 先頭トークンとの交差チェック | E-01 (52-54行目) | ○ |
| C-06 | HasExistingBannerで既存バナー確認 | E-01 (56行目, 91-96行目) | ○ |
| C-07 | 生成コード除外 | E-01 (77行目) | ○ |
| C-08 | TryGetBannerAsyncでバナー取得 | E-01 (122-146行目) | ○ |
| C-09 | TryGetSyntaxRootで既存Tree優先 | E-01 (130-133行目) | ○ |
| C-10 | IsCommentStartCharacterで早期フィルタリング | E-01 (137行目) | ○ |
| C-11 | BannerFileNamePlaceholder定義 | E-01 (26行目) | ○ |
| C-12 | GetEquivalenceKeyでファイル名置換 | E-01 (98-107行目) | ○ |
| C-13 | RefactorAllAsyncでFixAll処理 | E-01 (148-169行目) | ○ |
| C-14 | IFileBannerFactsService使用 | E-01 (93-94行目) | ○ |
| C-15 | AddFileBannerHelpers.CopyBannerAsync詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- AddFileBannerHelpers.csの詳細実装
  - 候補：`src/Features/Core/Portable/AddFileBanner/AddFileBannerHelpers.cs` を読み込み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理フローは確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ファイル名プレースホルダー置換のテストケースを確認
- [ ] 複数行バナーの取り扱いを確認
- [ ] EditorConfigとの連携動作を確認
