---
generated_at: 2026-02-10 13:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：137-メンバー選択

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **ダイアログXAMLの詳細**：未読み込み
  2. **VisualStudioPickMembersServiceの詳細**：未読み込み

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/PickMembers/IPickMembersService.cs`
- E-02: `src/Features/Core/Portable/PickMembers/PickMembersResult.cs`
- E-03: `src/VisualStudio/Core/Def/PickMembers/PickMembersDialogViewModel.cs`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IPickMembersServiceインターフェース定義 | E-01 (10-16行目) | ○ |
| C-02 | PickMembersOption構造 | E-01 (18-23行目) | ○ |
| C-03 | PickMembersResult.Canceled定義 | E-02 (11行目) | ○ |
| C-04 | Members/Options/SelectedAllプロパティ | E-02 (13-20行目) | ○ |
| C-05 | コンストラクタでメンバー/オプション初期化 | E-03 (30-48行目) | ○ |
| C-06 | Filterメソッド実装 | E-03 (50-57行目) | ○ |
| C-07 | SelectAll/DeselectAllメソッド | E-03 (59-71行目) | ○ |
| C-08 | SelectedIndexプロパティ | E-03 (73-92行目) | ○ |
| C-09 | MoveUpAutomationText/MoveDownAutomationText | E-03 (94-118行目) | ○ |
| C-10 | CanMoveUp/CanMoveDown判定 | E-03 (121-148行目) | ○ |
| C-11 | MoveUp/MoveDownメソッド | E-03 (150-164行目) | ○ |
| C-12 | OptionViewModel内部クラス | E-03 (175-200行目) | ○ |
| C-13 | ダイアログXAMLの詳細レイアウト | **根拠不足** | △ |
| C-14 | VisualStudioPickMembersServiceの実装詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- ダイアログXAMLの詳細レイアウト
  - 候補：`src/VisualStudio/Core/Def/PickMembers/PickMembersDialog.xaml`
- VisualStudioPickMembersServiceの実装詳細
  - 候補：`src/VisualStudio/Core/Def/PickMembers/VisualStudioPickMembersService.cs`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なロジックは確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ダイアログUIの操作性を確認
- [ ] 大量メンバー時のパフォーマンスを確認
- [ ] アクセシビリティ（キーボード操作等）を確認
