---
generated_at: 2026-02-10 13:20:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：138-ソリューションクローラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **WorkCoordinatorの詳細実装**：一部未確認
  2. **本番用SolutionCrawlerRegistrationServiceの詳細**：未読み込み

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/SolutionCrawler/SolutionCrawlerService.cs`
- E-02: `src/Features/Core/Portable/ExternalAccess/UnitTesting/SolutionCrawler/UnitTestingSolutionCrawlerRegistrationService.cs`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EnableSolutionCrawlerオプション定義 | E-01 (11行目) | ○ |
| C-02 | デフォルトtrue | E-01 (11行目) | ○ |
| C-03 | ExportWorkspaceService属性 | E-02 (21行目) | ○ |
| C-04 | アナライザープロバイダーのグループ化 | E-02 (47行目) | ○ |
| C-05 | IAsynchronousOperationListener使用 | E-02 (50行目) | ○ |
| C-06 | Registerメソッド実装 | E-02 (56-81行目) | ○ |
| C-07 | UnitTestingWorkCoordinator作成 | E-02 (70-73行目) | ○ |
| C-08 | AddAnalyzerProviderメソッド | E-02 (94-126行目) | ○ |
| C-09 | Reanalyzeメソッド | E-02 (128-152行目) | ○ |
| C-10 | GetAnalyzerProvidersメソッド | E-02 (154-171行目) | ○ |
| C-11 | TryGetProviderメソッド | E-02 (173-209行目) | ○ |
| C-12 | IsDefaultProvider判定 | E-02 (239-240行目) | ○ |
| C-13 | UnitTestingRegistration内部クラス | E-02 (260-279行目) | ○ |
| C-14 | WorkCoordinatorの詳細処理フロー | **根拠不足** | △ |
| C-15 | 本番用SolutionCrawlerRegistrationService | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- UnitTestingWorkCoordinatorの詳細実装
  - 候補：`src/Features/Core/Portable/ExternalAccess/UnitTesting/SolutionCrawler/UnitTestingWorkCoordinator.cs`
- 本番用SolutionCrawlerRegistrationServiceの詳細実装
  - 候補：`src/Features/Core/Portable/SolutionCrawler/SolutionCrawlerRegistrationService.cs`

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 本番実装とテスト用実装の差異を確認する必要あり

## 6) レビュアーチェックリスト（最小）
- [ ] 本番用とUnitTesting用の実装差異を確認
- [ ] キュー管理の詳細実装を確認
- [ ] パフォーマンス特性を確認
