---
generated_at: 2026-02-10 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-参照の検索

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/FindUsages/IFindUsagesService.cs` - サービスインターフェース
- E-02: `src/Features/Core/Portable/FindUsages/AbstractFindUsagesService.cs` - 抽象基底クラス
- E-03: `src/Features/Core/Portable/FindUsages/AbstractFindUsagesService_FindReferences.cs` - 参照検索実装
- E-04: `src/Features/Core/Portable/FindUsages/AbstractFindUsagesService_FindImplementations.cs` - 実装検索実装
- E-05: `src/Features/Core/Portable/FindUsages/DefinitionItem.cs` - 定義アイテムモデル
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FindReferencesAsyncで参照検索を実行 | E-01 (10-11行目) | ○ |
| C-02 | FindImplementationsAsyncで実装検索を実行 | E-01 (13-14行目) | ○ |
| C-03 | IFindUsagesContextで結果をストリーミング出力 | E-02, E-03 | ○ |
| C-04 | FindSymbolAtPositionAsyncでシンボル取得 | E-02 | ○ |
| C-05 | GetFeatureOptionsForStartingSymbolで検索オプション取得 | E-03 | ○ |
| C-06 | SymbolFinder.FindReferencesInCurrentProcessAsyncで検索 | E-03 | ○ |
| C-07 | DefinitionItemはTags、DisplayParts、SourceSpansを持つ | E-05 (59, 83, 89行目) | ○ |
| C-08 | DisplayIfNoReferencesで表示制御 | E-05 (101-111行目) | ○ |
| C-09 | DefinitionItem.Createで生成 | E-05 (221-238行目) | ○ |
| C-10 | CreateNonNavigableItemでナビゲーション不可アイテム生成 | E-05 (253-274行目) | ○ |
| C-11 | MetadataSymbolKeyでメタデータシンボル情報保持 | E-05 (45-47行目) | ○ |
| C-12 | GetNavigableLocationAsyncでナビゲーション位置取得 | E-05 (157行目) | ○ |
| C-13 | 書き込み参照と読み取り参照を区別 | E-03 (ReferenceLocation.IsWrittenTo) | ○ |
| C-14 | 結果をグループ化して表示 | E-02, E-03 | ○ |
| C-15 | リンクドファイルをサポート | E-02 | ○ |
| C-16 | OOP実行でUIスレッドをブロックしない | E-03 (RemoteHostClient) | ○ |
| C-17 | キャンセルトークンで中断可能 | E-01, E-02, E-03 | ○ |
| C-18 | ClassifiedSpansを生成 | E-05 (94行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり
- 0: 低リスク - インターフェースと実装の対応が明確

## 6) レビュアーチェックリスト（最小）
- [ ] ストリーミング表示の動作を確認
- [ ] カスケード検索オプションの動作を確認
- [ ] 大規模ソリューションでのパフォーマンスを確認
