---
generated_at: 2026-02-10 13:30:00
metrics:
  claims_total: 10
  claims_with_evidence: 9
  claims_without_evidence: 1
confidence_derived: 0.90
---

# 根拠レポート：140-プロジェクト管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：9 / 10、根拠なし：1
- 優先レビュー（高）
  1. **Visual Studio固有実装の詳細**：未読み込み

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/ProjectManagement/IProjectManagementService.cs`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IProjectManagementServiceインターフェース定義 | E-01 (13行目) | ○ |
| C-02 | IWorkspaceServiceを実装 | E-01 (13行目) | ○ |
| C-03 | GetFoldersメソッド定義 | E-01 (16行目) | ○ |
| C-04 | GetFoldersの引数（ProjectId, Workspace） | E-01 (16行目) | ○ |
| C-05 | GetFoldersの戻り値（IList<string>） | E-01 (16行目) | ○ |
| C-06 | GetDefaultNamespaceメソッド定義 | E-01 (19行目) | ○ |
| C-07 | GetDefaultNamespaceの引数（Project, Workspace） | E-01 (19行目) | ○ |
| C-08 | GetDefaultNamespaceの戻り値（string） | E-01 (19行目) | ○ |
| C-09 | コメントによる機能説明 | E-01 (10-11行目, 15, 18行目) | ○ |
| C-10 | Visual Studio固有実装の詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- Visual Studio固有実装の詳細
  - 候補：`src/VisualStudio/Core/Def/ProjectManagement/VisualStudioProjectManagementService.cs`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - インターフェースは明確に定義されている

## 6) レビュアーチェックリスト（最小）
- [ ] Visual Studio実装の存在と動作を確認
- [ ] フォルダ一覧取得のパフォーマンスを確認
- [ ] DefaultNamespaceの取得元（MSBuildプロパティ等）を確認
