---
generated_at: 2026-02-10 14:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：141-埋め込み言語サポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（100ms以内）**：根拠不足
  2. **カスタム埋め込み言語の拡張方法**：根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Features/Core/Portable/EmbeddedLanguages/IEmbeddedLanguagesProvider.cs`（13-18行目）
- E-02: `src/Features/Core/Portable/EmbeddedLanguages/IEmbeddedLanguage.cs`（12-23行目）
- E-03: `src/Features/Core/Portable/EmbeddedLanguages/AbstractEmbeddedLanguagesProvider.cs`（15-34行目）
- E-04: `src/Features/Core/Portable/EmbeddedLanguages/EmbeddedLanguageDetector.cs`（31-43行目、58-78行目、80-114行目、276-329行目）
- E-05: `src/Features/Core/Portable/EmbeddedLanguages/EmbeddedLanguageInfo.cs`（13-51行目）
- E-06: `src/Features/Core/Portable/EmbeddedLanguages/RegularExpressions/LanguageServices/RegexEmbeddedLanguage.cs`（14-47行目）
- E-07: `src/Features/Core/Portable/EmbeddedLanguages/Json/LanguageServices/JsonEmbeddedLanguage.cs`（10-14行目）
- E-08: `src/Features/Core/Portable/EmbeddedLanguages/DateAndTime/LanguageServices/DateAndTimeEmbeddedLanguage.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Regex、JSON、DateTimeの3言語をサポート | E-03（23行目で3言語を配列に設定） | ○ |
| C-02 | IEmbeddedLanguagesProviderがプロバイダーインターフェース | E-01（14行目でILanguageService継承） | ○ |
| C-03 | IEmbeddedLanguageが個別言語サービスインターフェース | E-02（12-23行目で定義） | ○ |
| C-04 | StringSyntax属性による言語識別 | E-04（503-537行目でIsMatchingStringSyntaxAttribute） | ○ |
| C-05 | コメントによる言語識別（lang=xxx） | E-04（80-114行目でHasLanguageComment） | ○ |
| C-06 | コメント指定が属性より優先 | E-04（289-291行目で先にコメントをチェック） | ○ |
| C-07 | ローカル変数追跡機能 | E-04（331-356行目でIsLocalConsumedByApiWithStringSyntaxAttribute） | ○ |
| C-08 | RegexEmbeddedLanguageの実装 | E-06（14-47行目） | ○ |
| C-09 | JsonEmbeddedLanguageは補完なし | E-07（13行目でCompletionProvider => null） | ○ |
| C-10 | EmbeddedLanguageInfoが言語情報保持 | E-05（13-51行目で構造体定義） | ○ |
| C-11 | 文字列リテラルトークンの検出 | E-04（68-69行目でIsAnyStringLiteral判定） | ○ |
| C-12 | 補間文字列テキストトークンの対応 | E-04（71-76行目でInterpolatedStringTextToken判定） | ○ |
| C-13 | EscapeTextメソッドの存在 | E-03（27-33行目で抽象メソッド定義） | ○ |
| C-14 | RegexLanguageDetectorの存在 | E-06（40行目で使用） | ○ |
| C-15 | CompletionProviderの提供 | E-02（22行目でEmbeddedLanguageCompletionProvider定義） | ○ |
| C-16 | 機能一覧に記載の説明と一致 | 機能一覧.csv No.141 | ○ |
| C-17 | パフォーマンス要件100ms以内 | **根拠なし** | △ |
| C-18 | MEFエクスポートによる拡張性 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件（C-17）**
  - 設計書に記載した100ms以内という要件は、一般的なIDE機能の応答性要件から推定したもの
  - 候補：パフォーマンステスト仕様書 / 性能要件定義書 / Issue tracker
- **MEFエクスポートによる拡張性（C-18）**
  - IEmbeddedLanguagesProviderがILanguageServiceを継承しているためMEFエクスポート対象と推定
  - 具体的なExportAttribute使用箇所の確認が必要
  - 候補：C#/VB固有のプロバイダー実装ファイル / 拡張性ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 主要機能の説明はソースコードと整合
- **1（中リスク）**: パフォーマンス要件は検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] IEmbeddedLanguagesProviderのMEFエクスポート方法を確認
- [ ] パフォーマンス要件の妥当性を開発チームに確認
- [ ] カスタム言語追加時の手順が記載されているか確認
- [ ] StringSyntax属性の.NETバージョン依存性を確認
