---
generated_at: 2026-02-10 14:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：142-インテントサポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（500ms以内）**：根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Features/Core/Portable/Intents/WellKnownIntents.cs`（10-16行目）
- E-02: `src/Features/Core/Portable/Intents/IntentResult.cs`（13-35行目）
- E-03: `src/Features/Core/Portable/Intents/IntentDataProvider.cs`（12-42行目）
- E-04: `src/Features/Core/Portable/Intents/IIntentProvider.cs`（12-20行目）
- E-05: `src/Features/Core/Portable/Intents/IntentProviderAttribute.cs`
- E-06: `src/Features/Core/Portable/Intents/IIntentProviderMetadata.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GenerateConstructorインテントのサポート | E-01（12行目でconst定義） | ○ |
| C-02 | AddConstructorParameterインテントのサポート | E-01（13行目でconst定義） | ○ |
| C-03 | Renameインテントのサポート | E-01（14行目でconst定義） | ○ |
| C-04 | DeleteParameterインテントのサポート | E-01（15行目でconst定義） | ○ |
| C-05 | IIntentProviderインターフェースの定義 | E-04（12行目でinterface定義） | ○ |
| C-06 | ComputeIntentAsyncメソッドの定義 | E-04（14-19行目でメソッド定義） | ○ |
| C-07 | IntentProcessorResultの構造 | E-02（13-35行目で構造体定義） | ○ |
| C-08 | Solutionプロパティの存在 | E-02（18行目でプロパティ定義） | ○ |
| C-09 | ChangedDocumentsプロパティの存在 | E-02（23行目でプロパティ定義） | ○ |
| C-10 | IntentDataProviderのJSON処理 | E-03（27-41行目でデシリアライズ実装） | ○ |
| C-11 | CamelCaseポリシーの使用 | E-03（19行目でJsonNamingPolicy.CamelCase設定） | ○ |
| C-12 | エラー時のFatalError.ReportAndCatch使用 | E-03（35行目で使用） | ○ |
| C-13 | 機能一覧に記載の説明と一致 | 機能一覧.csv No.142 | ○ |
| C-14 | パフォーマンス要件500ms以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件（C-14）**
  - 設計書に記載した500ms以内という要件は、一般的なリファクタリング操作の応答性要件から推定したもの
  - 候補：パフォーマンステスト仕様書 / 性能要件定義書 / 開発ガイドライン

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: コア機能の説明はソースコードと完全に整合
- **0（低リスク）**: インテント識別子はWellKnownIntentsで明確に定義

## 6) レビュアーチェックリスト（最小）
- [ ] 具体的なIIntentProvider実装（GenerateConstructorProvider等）の存在確認
- [ ] IntentProviderAttributeの使用例確認
- [ ] LSP経由でのインテント処理フローの確認
- [ ] Copilot連携時の実際のインテントデータ形式の確認
