---
generated_at: 2026-02-10 14:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：143-セマンティック検索機能

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（1秒以内）**：根拠不足
  2. **クエリ形式の具体例**：根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Features/Core/Portable/SemanticSearch/ExecuteQueryResult.cs`（23-50行目）
- E-02: `src/Features/Core/Portable/SemanticSearch/ISemanticSearchQueryService.cs`（12-48行目）
- E-03: `src/Features/Core/Portable/SemanticSearch/IRemoteSemanticSearchService.cs`（20-37行目、39-204行目）
- E-04: `src/Features/Core/Portable/SemanticSearch/SemanticSearchWorkspace.cs`（14-53行目）
- E-05: `src/Features/Core/Portable/SemanticSearch/QueryExecutionOptions.cs`
- E-06: `src/Features/Core/Portable/SemanticSearch/ISemanticSearchResultsObserver.cs`
- E-07: `src/Features/Core/Portable/SemanticSearch/SemanticSearchCopilotContext.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ISemanticSearchQueryServiceインターフェースの存在 | E-02（12行目でinterface定義） | ○ |
| C-02 | CompileQueryメソッドの定義 | E-02（20-26行目でメソッド定義） | ○ |
| C-03 | ExecuteQueryAsyncメソッドの定義 | E-02（35-41行目でメソッド定義） | ○ |
| C-04 | DiscardQueryメソッドの定義 | E-02（47行目でメソッド定義） | ○ |
| C-05 | ExecuteQueryResultの構造 | E-01（24-27行目でrecord struct定義） | ○ |
| C-06 | CompileQueryResultの構造 | E-01（36-39行目でrecord struct定義） | ○ |
| C-07 | CompiledQueryIdの存在 | E-01（48-49行目でrecord struct定義） | ○ |
| C-08 | IRemoteSemanticSearchServiceの存在 | E-03（20行目でinterface定義） | ○ |
| C-09 | OOP実行のRemoteSemanticSearchServiceProxy | E-03（39-204行目でclass定義） | ○ |
| C-10 | SemanticSearchWorkspaceの存在 | E-04（14行目でabstract class定義） | ○ |
| C-11 | ReferenceAssembliesDirectoryの定義 | E-04（21行目でstatic readonly定義） | ○ |
| C-12 | WorkspaceKind.SemanticSearchの使用 | E-04（15行目でWorkspaceKind.SemanticSearch使用） | ○ |
| C-13 | Copilot連携（SemanticSearchCopilotContext） | E-07 | ○ |
| C-14 | 機能一覧に記載の説明と一致 | 機能一覧.csv No.143 | ○ |
| C-15 | パフォーマンス要件1秒以内 | **根拠なし** | △ |
| C-16 | トップレベルC#コードとしてのクエリ形式 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件（C-15）**
  - 設計書に記載した1秒以内という要件は、ユーザー体験から推定したもの
  - 候補：パフォーマンステスト仕様書 / 性能要件定義書
- **クエリ形式（C-16）**
  - ISemanticSearchQueryServiceのコメントに「Query (top-level code)」と記載があるが、具体的な例がない
  - 候補：ユーザードキュメント / サンプルクエリ集

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: サービスインターフェースはソースコードと完全に整合
- **1（中リスク）**: クエリの具体的な書き方についてドキュメント化が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 具体的なクエリ例の確認（どのようなC#コードを書くか）
- [ ] OOPサービスの起動・通信方法の確認
- [ ] Copilot連携時のSemanticSearchCopilotContextの使用方法確認
- [ ] 参照アセンブリ（SemanticSearchRefs）の内容確認
