---
generated_at: 2026-02-10 14:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：144-テストサポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（100ms以内）**：根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Features/Core/Portable/Testing/ITestMethodFinder.cs`（13-31行目）
- E-02: `src/Features/Core/Portable/Testing/AbstractTestMethodFinder.cs`（17-113行目）
- E-03: `src/Features/Core/Portable/Testing/TestFrameworks/ITestFrameworkMetadata.cs`（7-13行目）
- E-04: `src/Features/Core/Portable/Testing/TestFrameworks/XUnitTestFrameworkMetadata.cs`（11-24行目）
- E-05: `src/Features/Core/Portable/Testing/TestFrameworks/NUnitTestFrameworkMetadata.cs`
- E-06: `src/Features/Core/Portable/Testing/TestFrameworks/MSTestTestFrameworkMetadata.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ITestMethodFinderインターフェースの存在 | E-01（13行目でinterface定義） | ○ |
| C-02 | GetPotentialTestMethodsAsyncメソッドの定義 | E-01（18-19行目でメソッド定義） | ○ |
| C-03 | IsTestMethodメソッドの定義 | E-01（24-25行目でメソッド定義） | ○ |
| C-04 | IsMatchメソッドの定義 | E-01（30行目でメソッド定義） | ○ |
| C-05 | xUnit属性（Fact、Theory）のサポート | E-04（22行目で属性名定義） | ○ |
| C-06 | ITestFrameworkMetadataインターフェース | E-03（7-13行目でinterface定義） | ○ |
| C-07 | MatchesAttributeSyntacticNameメソッド | E-03（12行目でメソッド定義） | ○ |
| C-08 | AbstractTestMethodFinderの抽象基底クラス | E-02（17行目でabstract class定義） | ○ |
| C-09 | 完全修飾名のネストクラス区切り変換 | E-02（66行目で'+'を'.'に変換） | ○ |
| C-10 | パラメータ部分の除去 | E-02（72-76行目で'('以降を除去） | ○ |
| C-11 | 継承関係による検出は行わない | E-01（17行目のコメントで明記） | ○ |
| C-12 | 構文のみのチェック | E-01（24行目のコメントでsyntax-only checksと明記） | ○ |
| C-13 | 機能一覧に記載の説明と一致 | 機能一覧.csv No.144 | ○ |
| C-14 | パフォーマンス要件100ms以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件（C-14）**
  - 設計書に記載した100ms以内という要件は、CodeLens表示の応答性要件から推定したもの
  - 候補：パフォーマンステスト仕様書 / 性能要件定義書 / CodeLens仕様

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: サービスインターフェースと実装はソースコードと完全に整合
- **0（低リスク）**: テストフレームワーク属性はMEFエクスポートで拡張可能

## 6) レビュアーチェックリスト（最小）
- [ ] C#/VB固有のAbstractTestMethodFinder実装の確認
- [ ] NUnit/MSTestの具体的な属性名の確認
- [ ] CodeLens統合時の呼び出しフローの確認
- [ ] テストエクスプローラーとの連携方法の確認
