---
generated_at: 2026-02-10 14:20:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：145-IL出力

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Features/Core/Portable/Emit/CompilationOutputs.cs`（19-177行目）
- E-02: `src/Features/Core/Portable/Emit/CompilationOutputFiles.cs`（12-53行目）
- E-03: `src/Features/Core/Portable/Emit/CompilationOutputFilesWithImplicitPdbPath.cs`
- E-04: `src/Features/Core/Portable/Emit/ICompilationOutputsProviderService.cs`（9-12行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CompilationOutputs抽象クラスの存在 | E-01（19行目でabstract class定義） | ○ |
| C-02 | OpenAssemblyStreamの抽象メソッド | E-01（143行目でabstract定義） | ○ |
| C-03 | OpenPdbStreamの抽象メソッド | E-01（152行目でabstract定義） | ○ |
| C-04 | OpenAssemblyMetadataメソッド | E-01（45-64行目でメソッド実装） | ○ |
| C-05 | OpenPdbメソッド | E-01（97-118行目でメソッド実装） | ○ |
| C-06 | ReadAssemblyModuleVersionIdメソッド | E-01（70-81行目でメソッド実装） | ○ |
| C-07 | 埋め込みPDBフォールバック | E-01（110-114行目で埋め込みPDB読み取り） | ○ |
| C-08 | prefetchパラメータの存在 | E-01（45行目でパラメータ定義） | ○ |
| C-09 | CompilationOutputFilesの存在 | E-02（12行目でsealed class定義） | ○ |
| C-10 | 絶対パス検証 | E-02（26-31行目でRequireAbsolutePath呼び出し） | ○ |
| C-11 | FileUtilities.OpenReadの使用 | E-02（42行目、52行目で使用） | ○ |
| C-12 | ICompilationOutputsProviderServiceの存在 | E-04（9行目でinterface定義） | ○ |
| C-13 | GetCompilationOutputsメソッド | E-04（11行目でメソッド定義） | ○ |
| C-14 | AssemblyDisplayPathプロパティ | E-01（24行目でabstract定義）、E-02（16行目で実装） | ○ |
| C-15 | 機能一覧に記載の説明と一致 | 機能一覧.csv No.145 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: すべての主張がソースコードと完全に整合

## 6) レビュアーチェックリスト（最小）
- [ ] Edit and Continue機能からの呼び出しフロー確認
- [ ] CompilationOutputFilesWithImplicitPdbPathの使用シーン確認
- [ ] ICompilationOutputsProviderServiceの具体的な実装確認
- [ ] デバッガーとの連携方法確認
