---
generated_at: 2026-02-10 14:25:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：146-LSIF出力

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **LSIF Generator Toolの具体的な実装**：根拠不足
  2. **頂点・辺の具体的な型定義**：根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Features/Core/Portable/LanguageServiceIndexFormat/SymbolMoniker.cs`（9-84行目）
- E-02: `src/Features/Core/Portable/LanguageServiceIndexFormat/WellKnownSymbolMonikerSchemes.cs`（7-11行目）
- E-03: `src/LanguageServer/Protocol/Protocol/Moniker/Moniker.cs`（16-46行目）
- E-04: `src/Features/Lsif/GeneratorTest/ProjectStructureTests.vb`（1-86行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SymbolMonikerクラスの存在 | E-01（9行目でsealed class定義） | ○ |
| C-02 | SchemeとIdentifierプロパティ | E-01（11-13行目でプロパティ定義） | ○ |
| C-03 | HasMonikerメソッドの存在 | E-01（15-42行目でstatic method定義） | ○ |
| C-04 | Createメソッドの存在 | E-01（44-84行目でstatic method定義） | ○ |
| C-05 | dotnet-namespaceスキーム | E-02（9行目でconst定義） | ○ |
| C-06 | dotnet-xml-docスキーム | E-02（10行目でconst定義） | ○ |
| C-07 | Local等のシンボルは対象外 | E-01（23-29行目でSymbolKindチェック） | ○ |
| C-08 | BuiltinOperatorは対象外 | E-01（33-34行目でMethodKindチェック） | ○ |
| C-09 | OriginalDefinitionチェック | E-01（18-19行目でEqualsチェック） | ○ |
| C-10 | 名前空間のMoniker形式 | E-01（53-56行目でToDisplayString使用） | ○ |
| C-11 | 通常シンボルのMoniker形式 | E-01（58-68行目でAssemblyName#DocId形式） | ○ |
| C-12 | パラメータのMoniker形式 | E-01（60-62行目でContainingDocId#Name形式） | ○ |
| C-13 | LSP Moniker型の存在 | E-03（16行目でsealed class定義） | ○ |
| C-14 | 機能一覧に記載の説明と一致 | 機能一覧.csv No.146 | ○ |
| C-15 | LSIF Generator Toolの実装 | **根拠不足** | △ |
| C-16 | LsifVertex/LsifEdge型定義 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **LSIF Generator Tool（C-15）**
  - SymbolMonikerはMoniker生成ロジックのみを提供
  - 実際のLSIF出力ツールの実装は別のリポジトリまたは未公開の可能性
  - 候補：microsoft/lsif-dotnet / 別のLSIF Generatorプロジェクト
- **LsifVertex/LsifEdge型（C-16）**
  - テストコード（ProjectStructureTests.vb）でGraph.LsifProject、Graph.LsifDocumentへの参照あり
  - 本体の型定義ファイルが見つからない
  - 候補：別のリポジトリ / NuGetパッケージ

## 5) リスクフラグ（レビュー観点）
- **1（中リスク）**: Moniker生成ロジックはソースコードと完全に整合するが、LSIF全体の出力フローは確認が必要
- **0（低リスク）**: WellKnownSymbolMonikerSchemesは明確に定義

## 6) レビュアーチェックリスト（最小）
- [ ] LSIF Generator Toolの実装場所の確認
- [ ] LsifProject/LsifDocument等のグラフ型定義の確認
- [ ] LineModeLsifJsonWriterの実装確認
- [ ] GitHub Code Navigationとの実際の連携フローの確認
- [ ] ソース生成ドキュメントのContents出力仕様の確認（テストコード参照）
