---
generated_at: 2026-02-10 10:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-ドキュメントハイライト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/DocumentHighlighting/IDocumentHighlightsService.cs` - インターフェースとデータ構造
- E-02: `src/Features/Core/Portable/DocumentHighlighting/AbstractDocumentHighlightsService.cs` - 抽象基底クラス実装
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HighlightSpanKindは4種類（None/Definition/Reference/WrittenReference） | E-01 (14-20行目) | ○ |
| C-02 | HighlightSpanはTextSpanとKindを保持 | E-01 (22-36行目) | ○ |
| C-03 | DocumentHighlightsはドキュメントとスパンリストを保持 | E-01 (38-42行目) | ○ |
| C-04 | GetDocumentHighlightsAsyncがサービスのエントリーポイント | E-01 (50-51行目) | ○ |
| C-05 | OOP実行を試み、失敗時はローカル実行 | E-02 (41-57行目) | ○ |
| C-06 | 埋め込み言語ハイライトをサポート | E-02 (94-109行目) | ○ |
| C-07 | SymbolFinder.FindSymbolAtPositionAsyncでシンボル取得 | E-02 (75-76行目) | ○ |
| C-08 | ShouldConsiderSymbolで匿名関数を除外 | E-02 (144-145行目) | ○ |
| C-09 | ShouldConsiderSymbolでアクセサを除外 | E-02 (145-150行目) | ○ |
| C-10 | SymbolFinder.FindReferencesInDocumentsInCurrentProcessAsyncで参照検索 | E-02 (125-127行目) | ○ |
| C-11 | 書き込み参照はIsWrittenToで判定 | E-02 (262行目) | ○ |
| C-12 | 位置交差チェックで無関係な結果を除外 | E-02 (88行目) | ○ |
| C-13 | エイリアスシンボルのフィルタリング | E-02 (169行目) | ○ |
| C-14 | 名前空間は定義に含めない | E-02 (284-285行目) | ○ |
| C-15 | スクリプトクラスは定義に含めない | E-02 (287-288行目) | ○ |
| C-16 | Nullability解析を無効化 | E-02 (68行目) | ○ |
| C-17 | Explicit=falseでバックグラウンド実行 | E-02 (124行目) | ○ |
| C-18 | コンストラクタのpartialパーツをフィルタ | E-02 (171-179行目) | ○ |
| C-19 | ジェネリック名の特別処理 | E-02 (322行目) | ○ |
| C-20 | インデクサーMemberCrefの特別処理 | E-02 (322行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり
- 0: 低リスク - データ構造と処理フローが明確

## 6) レビュアーチェックリスト（最小）
- [ ] 書き込み参照と読み取り参照の区別が正しく表示されるか確認
- [ ] 埋め込み言語（正規表現等）のハイライトが動作するか確認
- [ ] 位置交差チェックのロジックを確認
