---
generated_at: 2026-02-10 10:55:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-ナビゲーション

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/Navigation/INavigableItemsService.cs` - サービスインターフェース
- E-02: `src/Features/Core/Portable/Navigation/AbstractNavigableItemsService.cs` - 抽象基底クラス
- E-03: `src/Features/Core/Portable/Navigation/INavigableItem.cs` - ナビゲーションアイテムインターフェース
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GetNavigableItemsAsyncがサービスのエントリーポイント | E-01 (22-28行目) | ○ |
| C-02 | forSymbolTypeパラメータで型定義取得を制御 | E-01 (28行目) | ○ |
| C-03 | INavigableItemはGlyph、DisplayTaggedParts等を持つ | E-03 (16-49行目) | ○ |
| C-04 | NavigableDocumentでドキュメント情報を保持 | E-03 (51-88行目) | ○ |
| C-05 | Frozen Partial Semanticsで高速化試行 | E-02 (32行目) | ○ |
| C-06 | Frozen解析失敗時は通常解析を実行 | E-02 (33行目) | ○ |
| C-07 | IGoToDefinitionSymbolServiceでシンボル取得 | E-02 (47行目) | ○ |
| C-08 | SymbolFinder.FindSourceDefinitionAsyncでソース定義検索 | E-02 (51行目) | ○ |
| C-09 | TryGetPreferredSymbolAsyncで優先シンボル選択 | E-02 (52行目) | ○ |
| C-10 | IErrorTypeSymbolは結果から除外 | E-02 (54-55行目) | ○ |
| C-11 | GetSymbolType()で型シンボル取得 | E-02 (60行目) | ○ |
| C-12 | 型シンボルもソース定義検索を実行 | E-02 (64-65行目) | ○ |
| C-13 | NavigableItemFactory.GetItemsFromPreferredSourceLocationsで結果生成 | E-02 (41行目) | ○ |
| C-14 | NullableDisabledSemanticModelを使用 | E-02 (46行目) | ○ |
| C-15 | NavigableProject.FromProjectでプロジェクト情報取得 | E-03 (92-93行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり
- 0: 低リスク - 処理フローが明確

## 6) レビュアーチェックリスト（最小）
- [ ] Frozen Partial Semanticsの動作を確認
- [ ] 型定義取得の動作を確認
- [ ] エラー型除外のロジックを確認
