---
generated_at: 2026-02-10 11:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-NavigateTo

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/NavigateTo/INavigateToSearchService.cs` - サービスインターフェース
- E-02: `src/Features/Core/Portable/NavigateTo/INavigateToSearchResult.cs` - 結果インターフェース
- E-03: `src/Features/Core/Portable/NavigateTo/NavigateToSearcher.cs` - 検索オーケストレーター
- E-04: `src/Features/Core/Portable/NavigateTo/AbstractNavigateToSearchService.cs` - 抽象基底クラス
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | KindsProvidedで検索可能な種別を定義 | E-01 (15行目) | ○ |
| C-02 | CanFilterでフィルタリング可能か判定 | E-01 (16行目) | ○ |
| C-03 | SearchDocumentAsyncでドキュメント検索 | E-01 (18-23行目) | ○ |
| C-04 | SearchProjectsAsyncでプロジェクト検索 | E-01 (30-44行目) | ○ |
| C-05 | IAdvancedNavigateToSearchServiceでキャッシュ検索 | E-01 (51-71行目) | ○ |
| C-06 | SearchGeneratedDocumentsAsyncで生成ドキュメント検索 | E-01 (81-89行目) | ○ |
| C-07 | INavigateToSearchResultは各種プロパティを持つ | E-02 (13-24行目) | ○ |
| C-08 | NavigateToMatchKindの変換ロジック | E-02 (27-57行目) | ○ |
| C-09 | NavigateToDocumentSupportで検索対象を制御 | E-03 (25-31行目) | ○ |
| C-10 | NavigateToSearchScopeでスコープを定義 | E-03 (33-39行目) | ○ |
| C-11 | アクティブドキュメントを優先 | E-03 (80-81行目) | ○ |
| C-12 | 可視ドキュメントを次に優先 | E-03 (81-82行目) | ○ |
| C-13 | SearchAsyncがメイン検索処理 | E-03 (132-182行目) | ○ |
| C-14 | IsFullyLoadedAsyncでロード状態確認 | E-03 (160行目) | ○ |
| C-15 | 未ロード時はキャッシュ検索 | E-03 (267行目) | ○ |
| C-16 | GetOrderedProjectsToProcessで優先順位付け | E-03 (284-320行目) | ○ |
| C-17 | RemoteKeepAliveSessionでOOP接続維持 | E-03 (247行目) | ○ |
| C-18 | 並列検索をサポート | E-03 (370行目) | ○ |
| C-19 | 重複除去をサポート | E-03 (394-401行目) | ○ |
| C-20 | 生成ドキュメントはトポロジカル順序で検索 | E-03 (471-494行目) | ○ |
| C-21 | AllKindsで12種類の種別を定義 | E-04 (18-30行目) | ○ |
| C-22 | RoslynNavigateToItemから結果を生成 | E-04 (39-52行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり
- 0: 低リスク - 検索ロジックとスコープ制御が明確

## 6) レビュアーチェックリスト（最小）
- [ ] マッチ種別の優先順位が正しく動作するか確認
- [ ] キャッシュ検索と完全検索の動作を確認
- [ ] 生成ドキュメント検索の動作を確認
