---
generated_at: 2026-02-10 11:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-ナビゲーションバー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/NavigationBar/INavigationBarItemService.cs` - サービスインターフェース
- E-02: `src/Features/Core/Portable/NavigationBar/AbstractNavigationBarItemService.cs` - 抽象基底クラス
- E-03: `src/Features/Core/Portable/NavigationBar/NavigationBarItems/RoslynNavigationBarItem.cs` - アイテム基底クラス
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GetItemsAsyncがサービスのエントリーポイント | E-01 (14行目) | ○ |
| C-02 | supportsCodeGeneration、frozenPartialSemanticsパラメータ | E-01 (14行目) | ○ |
| C-03 | RoslynNavigationBarItemはKind、Text、Glyph等を持つ | E-03 (16-23行目) | ○ |
| C-04 | ChildItemsで子アイテムを保持 | E-03 (23行目) | ○ |
| C-05 | Dehydrateでシリアライズ | E-03 (43行目) | ○ |
| C-06 | OOP試行とローカルフォールバック | E-02 (21-41行目) | ○ |
| C-07 | RemoteHostClient.TryInvokeAsyncでOOP実行 | E-02 (24行目) | ○ |
| C-08 | GetItemsInCurrentProcessAsyncでローカル処理 | E-02 (19行目) | ○ |
| C-09 | GetSymbolLocationでシンボル位置取得 | E-02 (43-88行目) | ○ |
| C-10 | DeclaringSyntaxReferencesで宣言位置取得 | E-02 (58行目) | ○ |
| C-11 | 現在ファイルの参照を優先 | E-02 (58-71行目) | ○ |
| C-12 | 別ファイルへのナビゲーション情報も保持 | E-02 (75-86行目) | ○ |
| C-13 | ISymbolDeclarationServiceで宣言取得 | E-02 (90-94行目) | ○ |
| C-14 | SerializableNavigationBarItem.Rehydrateで復元 | E-02 (35行目) | ○ |
| C-15 | Bolded/Grayedで表示スタイル制御 | E-03 (20-21行目) | ○ |
| C-16 | Indentでインデントレベル制御 | E-03 (22行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり
- 0: 低リスク - データ構造と処理フローが明確

## 6) レビュアーチェックリスト（最小）
- [ ] partial型の別ファイル表示が正しく動作するか確認
- [ ] 入れ子型のインデント表示を確認
- [ ] VBでのイベントハンドラ生成機能を確認
