---
generated_at: 2026-02-10 11:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-スニペット

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/Snippets/ISnippetService.cs` - サービスインターフェース
- E-02: `src/Features/Core/Portable/Snippets/AbstractSnippetService.cs` - サービス実装
- E-03: `src/Features/Core/Portable/Snippets/SnippetProviders/AbstractSnippetProvider.cs` - プロバイダ基底クラス
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GetSnippetsでコンテキストに基づいてスニペット取得 | E-01 (17行目) | ○ |
| C-02 | GetSnippetProviderで識別子からプロバイダ取得 | E-01 (23行目) | ○ |
| C-03 | MEFでプロバイダを取得 | E-02 (17行目) | ○ |
| C-04 | Contract.ThrowIfFalseで識別子検証 | E-02 (30行目) | ○ |
| C-05 | IsValidSnippetLocationでフィルタリング | E-02 (44行目) | ○ |
| C-06 | EnsureSnippetsLoadedで遅延ロード | E-02 (51-69行目) | ○ |
| C-07 | Identifier、Descriptionプロパティ | E-03 (25-26行目) | ○ |
| C-08 | AdditionalFilterTextsで追加フィルタ | E-03 (28行目) | ○ |
| C-09 | FindSnippetAnnotationでスニペット識別 | E-03 (30行目) | ○ |
| C-10 | IsValidSnippetLocationCoreで言語固有判定 | E-03 (36行目) | ○ |
| C-11 | GenerateSnippetTextChangesAsyncでテキスト変更生成 | E-03 (41行目) | ○ |
| C-12 | GetTargetCaretPositionでキャレット位置計算 | E-03 (46行目) | ○ |
| C-13 | GetPlaceHolderLocationsListAsyncでプレースホルダー計算 | E-03 (51-53行目) | ○ |
| C-14 | IsInNonUserCodeで非ユーザーコード除外 | E-03 (59行目) | ○ |
| C-15 | GetSnippetChangeAsyncがメイン処理 | E-03 (72-118行目) | ○ |
| C-16 | GenerateElasticTriviaForSyntaxでトリビア追加 | E-03 (123-140行目) | ○ |
| C-17 | ImportAdder.AddImportsFromSymbolAnnotationAsyncでインポート追加 | E-03 (151-152行目) | ○ |
| C-18 | Simplifier.ReduceAsyncで簡略化 | E-03 (154行目) | ○ |
| C-19 | Formatter.FormatAsyncでフォーマット | E-03 (157-160行目) | ○ |
| C-20 | AddIndentationToDocumentAsyncでインデント調整 | E-03 (236-248行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり
- 0: 低リスク - 処理フローとAPI構造が明確

## 6) レビュアーチェックリスト（最小）
- [ ] 各スニペットの有効位置判定が正しく動作するか確認
- [ ] プレースホルダーのTab移動が正しく動作するか確認
- [ ] インポート追加が正しく動作するか確認
