---
generated_at: 2026-02-10 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：22-コードリファクタリング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり、重点レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Features/Core/Portable/CodeRefactorings/CodeRefactoringService.cs` 1-303行目
- E-02: `src/Features/Core/Portable/CodeRefactorings/ICodeRefactoringService.cs`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` 23行目
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 27行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コード品質向上のための変換操作を提供 | E-03 | ○ |
| C-02 | MEFでエクスポートされシングルトン | E-01 (28-30行目) | ○ |
| C-03 | 言語・ドキュメント種別・拡張子でProvider分類 | E-01 (45-72行目, 80-119行目) | ○ |
| C-04 | 優先度でフィルタリング | E-01 (152-156行目, 192-196行目) | ○ |
| C-05 | 並列実行で候補取得 | E-01 (180-235行目) | ○ |
| C-06 | HasRefactoringsAsyncで早期終了 | E-01 (121-178行目) | ○ |
| C-07 | Interactive Workspaceでは制限あり | E-01 (98-102行目) | ○ |
| C-08 | プロジェクトレベルのProvider対応 | E-01 (285-303行目) | ○ |
| C-09 | ExtensionManagerで例外キャッチ | E-01 (243-255行目) | ○ |
| C-10 | FixAllProviderInfo取得 | E-01 (271-272行目) | ○ |
| C-11 | 500ms以上で個別ログ | E-01 (213行目) | ○ |
| C-12 | 処理シーケンスの正確性 | E-01 (180-235行目) | ○ |
| C-13 | Providerの順序でソート | E-01 (233-234行目) | ○ |
| C-14 | DocumentKindで対象を限定可能 | E-01 (78-79行目, ExportCodeRefactoringProviderAttribute参照) | ○ |
| C-15 | ファイル拡張子で対象を限定可能 | E-01 (78-79行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 処理フローの記述は正確（ソースコードと一致）
- 0: データ構造の記述は正確
- 0: Provider選択ロジックも正確に記述

## 6) レビュアーチェックリスト（最小）
- [ ] コードリーディングガイドの行番号が最新のソースと一致するか確認
- [ ] プロジェクトレベルProvider(NuGet経由)の動作を必要に応じて確認
