---
generated_at: 2026-02-10 10:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：23-コードクリーンアップ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり、重点レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Workspaces/Core/Portable/CodeCleanup/AbstractCodeCleanerService.cs` 1-674行目
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` 24行目
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 28行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 複数のプロバイダーを順次適用 | E-01 (454-518行目) | ○ |
| C-02 | 空範囲時は元のドキュメントを返却 | E-01 (34-38行目, 77-82行目) | ○ |
| C-03 | 全体クリーンアップ時は最適化パスを使用 | E-01 (44-49行目, 87-91行目) | ○ |
| C-04 | アノテーションでSpan追跡 | E-01 (269-315行目) | ○ |
| C-05 | SpanMarkerでエッジケース処理 | E-01 (633-672行目) | ○ |
| C-06 | GetTextSpansFromAnnotationでSpan復元 | E-01 (114-144行目) | ○ |
| C-07 | GetSpansToAvoidで回避範囲を除外 | E-01 (520-533行目) | ○ |
| C-08 | 変更なしの場合は元のドキュメント返却 | E-01 (507-516行目, 577-586行目) | ○ |
| C-09 | Logger.LogBlockでロギング | E-01 (31行目, 462行目, 494行目) | ○ |
| C-10 | DEBUG時のみエラー検証 | E-01 (468-470行目, 499-504行目) | ○ |
| C-11 | ICodeCleanupProvider.CleanupAsync呼び出し | E-01 (496行目, 573行目) | ○ |
| C-12 | SyntaxNode版APIもサポート | E-01 (73-112行目, 535-588行目) | ○ |
| C-13 | 言語サービスとして登録 | E-01 (24行目 ICodeCleanerServiceを実装) | ○ |
| C-14 | ToNormalizedSpansで範囲正規化 | E-01 (44行目, 86行目) | ○ |
| C-15 | GetNonOverlappingSpansで重複排除 | E-01 (273行目, 320-351行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 処理フローの記述は正確（ソースコードと一致）
- 0: データ構造の記述は正確
- 0: Span追跡アルゴリズムも正確に記述

## 6) レビュアーチェックリスト（最小）
- [ ] コードリーディングガイドの行番号が最新のソースと一致するか確認
- [ ] C#/VB固有のGetDefaultProvidersの内容を必要に応じて確認
