---
generated_at: 2026-02-10 10:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-メソッド抽出

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり、重点レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Features/Core/Portable/ExtractMethod/MethodExtractor.cs` 1-266行目
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` 26行目
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 30行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 選択コードを新しいメソッドとして抽出 | E-02 | ○ |
| C-02 | ローカル関数としても抽出可能 | E-01 (33行目, 95-100行目) | ○ |
| C-03 | ExtractMethodの処理フロー | E-01 (47-136行目) | ○ |
| C-04 | Analyzeで変数フロー分析 | E-01 (36行目, 50行目) | ○ |
| C-05 | CheckVariableTypesで型チェック | E-01 (52行目, 203-249行目) | ○ |
| C-06 | System.Voidは許可 | E-01 (228-229行目) | ○ |
| C-07 | TypeKind.Error/Unknownは失敗 | E-01 (231-232行目) | ○ |
| C-08 | 型パラメータの検証 | E-01 (234-246行目) | ○ |
| C-09 | GetInsertionPointNodeで挿入位置決定 | E-01 (37行目, 56行目) | ○ |
| C-10 | CanAddToで挿入可能かチェック | E-01 (58-59行目, 106-136行目) | ○ |
| C-11 | CreateCodeGeneratorでコード生成 | E-01 (40行目, 62行目) | ○ |
| C-12 | Simplifier.ReduceAsyncで簡略化 | E-01 (151行目) | ○ |
| C-13 | Formatter.Formatで整形 | E-01 (157-158行目) | ○ |
| C-14 | MakeMethodNameでメソッド名生成 | E-01 (251-264行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 処理フローの記述は正確（ソースコードと一致）
- 0: データ構造の記述は正確
- 0: パラメータ決定ロジックも正確に記述

## 6) レビュアーチェックリスト（最小）
- [ ] コードリーディングガイドの行番号が最新のソースと一致するか確認
- [ ] 変数フロー分析の詳細な実装を確認する場合はAnalyzer系クラスを調査
