---
generated_at: 2026-02-10 10:55:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-インターフェース抽出

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり、重点レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Features/Core/Portable/ExtractInterface/AbstractExtractInterfaceService.cs` 1-444行目
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` 27行目
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 31行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 既存の型からインターフェースを抽出 | E-02 | ○ |
| C-02 | TypeKind.Extensionは除外 | E-01 (92行目) | ○ |
| C-03 | publicメンバーのみ抽出可能 | E-01 (426行目) | ○ |
| C-04 | Cloneメソッドは除外 | E-01 (427行目) | ○ |
| C-05 | event/method/propertyのみ抽出可能 | E-01 (432-439行目) | ○ |
| C-06 | 新規ファイルへの抽出 | E-01 (151-159行目, 173-213行目) | ○ |
| C-07 | 同一ファイルへの抽出 | E-01 (161-167行目, 215-252行目) | ○ |
| C-08 | interface間抽出時は元の型を更新しない | E-01 (320-323行目) | ○ |
| C-09 | デフォルトインターフェース名は"I" + 型名 | E-01 (263行目) | ○ |
| C-10 | CreateInterfaceMembersでメンバー生成 | E-01 (364-422行目) | ○ |
| C-11 | abstract, staticの修飾子を設定 | E-01 (376, 385, 405行目) | ○ |
| C-12 | AddInterfaceTypeで元の型を更新 | E-01 (342行目) | ○ |
| C-13 | Formatter.FormatAsync, Simplifier.ReduceAsyncで整形 | E-01 (289-301行目) | ○ |
| C-14 | AnalyzeTypeAtPositionAsyncで型分析 | E-01 (78-107行目) | ○ |
| C-15 | IExtractInterfaceOptionsServiceでUI連携 | E-01 (267-268行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 処理フローの記述は正確（ソースコードと一致）
- 0: データ構造の記述は正確
- 0: メンバー生成ロジックも正確に記述

## 6) レビュアーチェックリスト（最小）
- [ ] コードリーディングガイドの行番号が最新のソースと一致するか確認
- [ ] UpdateMembersWithExplicitImplementationsAsyncの詳細が必要な場合は言語別実装を調査
