---
generated_at: 2026-02-10 11:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：27-クラス抽出

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり、重点レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Features/Core/Portable/ExtractClass/AbstractExtractClassRefactoringProvider.cs` 1-138行目
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` 28行目
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 32行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 選択メンバーを基底クラスとして抽出 | E-02 | ○ |
| C-02 | 基底クラスがSystem.Object以外の場合は不可 | E-01 (85-88行目, 127-130行目, 137行目) | ○ |
| C-03 | MemberAndDestinationValidator.IsMemberValidでメンバー検証 | E-01 (66行目) | ○ |
| C-04 | 同一型内のメンバーのみ有効 | E-01 (99-102行目) | ○ |
| C-05 | IExtractClassOptionsServiceがない場合は利用不可 | E-01 (30-35行目) | ○ |
| C-06 | GetSelectedNodesAsyncでメンバー取得 | E-01 (54行目) | ○ |
| C-07 | GetSelectedClassDeclarationAsyncでクラス取得 | E-01 (113行目) | ○ |
| C-08 | ExtractClassWithDialogCodeAction生成 | E-01 (105-106行目, 133-134行目) | ○ |
| C-09 | メンバー選択時とクラス選択時の両方をサポート | E-01 (37-49行目) | ○ |
| C-10 | 型宣言ノードが見つからない場合は不可 | E-01 (92-97行目) | ○ |
| C-11 | CodeRefactoringKind.Extract | E-01 (25行目) | ○ |
| C-12 | 処理フローの正確性 | E-01 (27-50行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 処理フローの記述は正確（ソースコードと一致）
- 0: データ構造の記述は正確
- 0: HasBaseType判定ロジックも正確に記述

## 6) レビュアーチェックリスト（最小）
- [ ] コードリーディングガイドの行番号が最新のソースと一致するか確認
- [ ] ExtractClassWithDialogCodeActionの内部実装が必要な場合は別途調査
