---
generated_at: 2026-02-10 11:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-シグネチャ変更

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり、重点レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Features/Core/Portable/ChangeSignature/AbstractChangeSignatureService.cs` 1-1085行目
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` 29行目
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 33行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | パラメータの追加・削除・並び替えを行う | E-02 | ○ |
| C-02 | IMethodSymbol, IPropertySymbolのみ対象 | E-01 (144-147行目) | ○ |
| C-03 | メタデータ定義シンボルは変更不可 | E-01 (149-152行目) | ○ |
| C-04 | デリゲートBeginInvokeをDelegateInvokeMethodに変換 | E-01 (116-125行目) | ○ |
| C-05 | イベントをDelegateInvokeMethodに変換 | E-01 (127-130行目) | ○ |
| C-06 | レコードPrimaryConstructorをサポート | E-01 (138-142行目) | ○ |
| C-07 | FindChangeSignatureReferencesAsync | E-01 (225-244行目) | ○ |
| C-08 | CreateUpdatedSolutionAsync | E-01 (246-441行目) | ○ |
| C-09 | PermuteArgumentsで引数並び替え | E-01 (470-574行目) | ○ |
| C-10 | params配列の特別処理 | E-01 (521-522行目, 799-801行目) | ○ |
| C-11 | 名前付き引数の自動追加 | E-01 (524-527行目) | ○ |
| C-12 | メタデータ参照時の確認メッセージ | E-01 (281-285行目, 356-358行目) | ○ |
| C-13 | 並列処理で複数ドキュメント更新 | E-01 (418-433行目) | ○ |
| C-14 | Formatter, Simplifier, ImportAdderで整形 | E-01 (406-412行目, 426-428行目) | ○ |
| C-15 | テレメトリ記録 | E-01 (438行目) | ○ |
| C-16 | ドキュメントコメントの更新 | E-01 (971-1041行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 処理フローの記述は正確（ソースコードと一致）
- 0: データ構造の記述は正確
- 0: params配列処理も正確に記述

## 6) レビュアーチェックリスト（最小）
- [ ] コードリーディングガイドの行番号が最新のソースと一致するか確認
- [ ] 言語固有の実装(C#/VB)が必要な場合は別途調査
