---
generated_at: 2026-02-10 10:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-コンパイラ共通基盤

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全ての主張がソースコードから確認可能

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Compilers/Core/Portable/CommandLine/CommonCompiler.cs`
- E-02: `src/Compilers/Core/Portable/Compilation/Compilation.cs`
- E-03: `src/Compilers/Core/Portable/Compilation/CompilationOptions.cs`
- E-04: `src/Compilers/Core/Portable/Compilation/EmitResult.cs`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | C#とVBで共通使用される基盤機能を提供 | E-01 (63行目コメント "Base class for csc.exe, csi.exe, vbc.exe") | ○ |
| C-02 | BuildPaths構造体で4つのパスを管理 | E-01 (28-60行目 BuildPaths定義) | ○ |
| C-03 | Failed=1, Succeeded=0の終了コード定義 | E-01 (67-68行目) | ○ |
| C-04 | MessageProvider, Argumentsプロパティ提供 | E-01 (76-77行目) | ○ |
| C-05 | CreateCompilationは抽象メソッド | E-01 (95-100行目 abstract CreateCompilation) | ○ |
| C-06 | コンストラクタでレスポンスファイル処理 | E-01 (130-133行目 responseFile処理) | ○ |
| C-07 | CommandLineParser.Parseで引数解析 | E-01 (135行目) | ○ |
| C-08 | Compilationは不変オブジェクト | E-02 (34-41行目コメント "immutable representation") | ○ |
| C-09 | Compilationはオンデマンドでデータ生成 | E-02 (36-37行目コメント "on-demand, and will realize and cache") | ○ |
| C-10 | 差分コンパイルをサポート | E-02 (37-40行目コメント "new compilation from existing compilation with small deltas") | ○ |
| C-11 | IsCaseSensitiveは抽象プロパティ | E-02 (57行目 abstract bool IsCaseSensitive) | ○ |
| C-12 | Language抽象プロパティで言語識別 | E-02 (132行目 "C#" or "Visual Basic") | ○ |
| C-13 | CreateAnalyzerDriver抽象メソッド | E-02 (127行目) | ○ |
| C-14 | EmbeddedSourcePathsで二重読み込み防止 | E-01 (83-86行目コメント) | ○ |
| C-15 | フォールバックエンコーディング対応 | E-01 (71-74行目 _fallbackEncoding) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認可能な構造記述
- 0: 低リスク - データ構造の定義記述
- 0: 低リスク - 抽象メソッド/プロパティの記述

## 6) レビュアーチェックリスト（最小）
- [ ] BuildPaths構造体の4フィールドが正確か確認
- [ ] CommonCompilerの主要プロパティが網羅されているか確認
- [ ] Compilationクラスの不変性に関する記述が正確か確認
- [ ] 抽象メソッド/プロパティの一覧が完全か確認
