---
generated_at: 2026-02-10 11:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-名前空間の移動

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり、重点レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Features/Core/Portable/MoveToNamespace/AbstractMoveToNamespaceService.cs` 1-326行目
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` 31行目
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 35行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 型または名前空間を別の名前空間に移動 | E-02 | ○ |
| C-02 | IMoveToNamespaceOptionsServiceがない場合は不可 | E-01 (52-53行目) | ○ |
| C-03 | ネストされた名前空間はサポート外 | E-01 (97行目, 117-118行目) | ○ |
| C-04 | グローバル名前空間の単一型のみ移動可能 | E-01 (127-135行目) | ○ |
| C-05 | ネストされた複数型はサポート外 | E-01 (118行目) | ○ |
| C-06 | IChangeNamespaceService.CanChangeNamespaceAsyncで判定 | E-01 (100行目, 152行目) | ○ |
| C-07 | Container種別による分岐 | E-01 (178-183行目) | ○ |
| C-08 | MoveItemsInNamespaceAsync | E-01 (214-235行目) | ○ |
| C-09 | MoveTypeToNamespaceAsync | E-01 (237-273行目) | ○ |
| C-10 | IMoveTypeService.GetModifiedSolutionAsync | E-01 (249-253行目) | ○ |
| C-11 | PropagateChangeToLinkedDocumentsAsync | E-01 (258-259行目, 275-285行目) | ○ |
| C-12 | IChangeNamespaceService.ChangeNamespaceAsync | E-01 (228-232行目) | ○ |
| C-13 | 新しいシンボル名の計算 | E-01 (287-296行目) | ○ |
| C-14 | 既存名前空間一覧の取得 | E-01 (305-312行目) | ○ |
| C-15 | IsContainedInNamespaceDeclarationの位置制限 | E-01 (91行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 処理フローの記述は正確（ソースコードと一致）
- 0: データ構造の記述は正確
- 0: Container種別による分岐処理も正確に記述

## 6) レビュアーチェックリスト（最小）
- [ ] コードリーディングガイドの行番号が最新のソースと一致するか確認
- [ ] IChangeNamespaceServiceの内部実装が必要な場合は別途調査
