---
generated_at: 2026-02-10 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：31-静的メンバーの移動

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値基準の根拠不足
  2. **トランザクション仕様**：実装詳細の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Features/Core/Portable/MoveStaticMembers/AbstractMoveStaticMembersRefactoringProvider.cs`
- E-02: `src/Features/Core/Portable/MoveStaticMembers/MoveStaticMembersWithDialogCodeAction.cs`
- E-03: `src/Features/Core/Portable/MoveStaticMembers/MoveStaticMembersOptions.cs`
- E-04: `src/Features/Core/Portable/MoveStaticMembers/IMoveStaticMembersOptionsService.cs`
- E-05: `src/Features/Core/Portable/PullMemberUp/MembersPuller.cs`
- E-06: `src/Features/Core/Portable/PullMemberUp/MemberAndDestinationValidator.cs`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 静的メンバーを別の型に移動するリファクタリング機能である | E-01 (行17, 41), E-08 | ○ |
| C-02 | PullMemberUp機能と連携してメンバー移動を行う | E-02 (行140-141), E-05 | ○ |
| C-03 | MemberAndDestinationValidator.IsMemberValidで検証を行う | E-01 (行41), E-06 | ○ |
| C-04 | 選択されたすべてのメンバーは同一の型に属する必要がある | E-01 (行50-54) | ○ |
| C-05 | Enum型のメンバーは移動対象外 | E-01 (行57-61) | ○ |
| C-06 | 移動先は既存型または新規型を選択可能 | E-02 (行61-79), E-03 (行11-67) | ○ |
| C-07 | FindMemberReferencesAsyncで参照を検索 | E-02 (行361-390) | ○ |
| C-08 | QualifyStaticMemberReferencesAsyncで静的参照を完全修飾化 | E-02 (行396-449) | ○ |
| C-09 | 画面No.10と画面No.11が関連画面 | E-07 (行15-16) | ○ |
| C-10 | ExtractTypeHelpers.AddTypeToNewFileAsyncで新規型を作成 | E-02 (行102-110) | ○ |
| C-11 | 拡張メソッドの移動時はstaticメソッド呼び出しに展開 | E-02 (行293-317) | ○ |
| C-12 | VBのModuleは静的クラスとして扱われる | E-02 (行148-154) | ○ |
| C-13 | ソースコード内の型のみ対象（生成コード除外） | E-06 (行24-26) | ○ |
| C-14 | GetSelectedNodesAsyncは抽象メソッド | E-01 (行18) | ○ |
| C-15 | ComputeRefactoringsAsyncがエントリーポイント | E-01 (行20-71) | ○ |
| C-16 | MoveStaticMembersOptionsは2つのコンストラクタを持つ | E-03 (行36-67) | ○ |
| C-17 | IMoveStaticMembersOptionsServiceでダイアログオプションを取得 | E-04, E-02 (行38-41) | ○ |
| C-18 | RefactorAndMoveAsyncで参照更新とメンバー移動を実行 | E-02 (行167-231) | ○ |
| C-19 | SymbolFinder.FindReferencesAsyncで参照検索 | E-02 (行379) | ○ |
| C-20 | ApplyChangesOperationで変更を適用 | E-02 (行78, 143) | ○ |
| C-21 | 型パラメータの抽出ロジックが存在 | E-02 (行87-91) | ○ |
| C-22 | SolutionEditorを使用して変更を管理 | E-02 (行271) | ○ |
| C-23 | 非静的メンバーは対象外 | E-01 (行41) | ○ |
| C-24 | パフォーマンス要件：大規模ソリューションでも非同期実行 | **根拠なし** | △ |
| C-25 | トランザクション：単一のApplyChangesOperationで適用 | E-02 (行78, 143) - 部分的確認 | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値基準
  - 候補：パフォーマンステスト結果 / 設計ガイドライン / 要件定義書
- トランザクション仕様の詳細（ロールバック動作の確認）
  - 候補：Workspace APIドキュメント / 単体テストコード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の基本動作は十分に根拠あり
- 1: 中リスク - パフォーマンス要件は実装から推測した内容であり、具体的な基準は不明

## 6) レビュアーチェックリスト（最小）
- [ ] 静的メンバーの検証ロジック（Enum除外、同一型チェック）が正しいか
- [ ] 参照更新のロジックが漏れなく実装されているか
- [ ] 新規型作成時の名前空間・ファイルパス設定が適切か
- [ ] 拡張メソッドの展開処理が正しいか
