---
generated_at: 2026-02-10 10:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：32-メンバーの引き上げ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **MemberAnalysisResult構造**：ファイル内容の詳細確認が必要
  2. **抽象クラス変更ロジック**：条件の詳細確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/PullMemberUp/AbstractPullMemberUpRefactoringProvider.cs`
- E-02: `src/Features/Core/Portable/PullMemberUp/MembersPuller.cs`
- E-03: `src/Features/Core/Portable/PullMemberUp/PullMembersUpOptions.cs`
- E-04: `src/Features/Core/Portable/PullMemberUp/MemberAndDestinationValidator.cs`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 派生クラスのメンバーを基底クラスまたはインターフェースに移動する | E-01 (行26-27), E-06 | ○ |
| C-02 | メソッド、プロパティ、イベント、フィールドが対象 | E-04 (行45-49) | ○ |
| C-03 | 暗黙的に宣言されたメンバーは対象外 | E-04 (行36-39) | ○ |
| C-04 | フィールドは基底クラスにのみ引き上げ可能 | E-01 (行84-86) | ○ |
| C-05 | ソースコード内の型のみ対象 | E-04 (行24-26) | ○ |
| C-06 | 生成コードファイルは対象外 | E-04 (行25) | ○ |
| C-07 | 静的メンバーを非静的に変換 | E-02 (行153) | ○ |
| C-08 | 非publicメンバーをpublic化 | E-02 (行158-167) | ○ |
| C-09 | 画面No.7、8、13が関連画面 | E-05 (行11-14, 18) | ○ |
| C-10 | PullMembersIntoInterfaceAsyncでインターフェースへ引き上げ | E-02 (行91-147) | ○ |
| C-11 | PullMembersIntoClassAsyncでクラスへ引き上げ | E-02 (行266-397) | ○ |
| C-12 | MakeAbstractVersionで抽象メンバー生成 | E-02 (行442-466) | ○ |
| C-13 | TryComputeCodeActionでクイックアクション生成 | E-02 (行38-57) | ○ |
| C-14 | PullMembersUpAsyncで処理を振り分け | E-02 (行59-71) | ○ |
| C-15 | ComputeRefactoringsAsyncがエントリーポイント | E-01 (行24-76) | ○ |
| C-16 | FindAllValidDestinationsで移動先検索 | E-01 (行78-89) | ○ |
| C-17 | インターフェース間の引き上げで元を削除 | E-02 (行127-132) | ○ |
| C-18 | 抽象として引き上げ時にoverride追加 | E-02 (行340-348) | ○ |
| C-19 | ICodeGenerationService.AddMembersでメンバー追加 | E-02 (行114, 306-307) | ○ |
| C-20 | IAddImportsServiceでimport追加 | E-02 (行371-378) | ○ |
| C-21 | IRemoveUnnecessaryImportsServiceで不要import削除 | E-02 (行380-384) | ○ |
| C-22 | SolutionEditorで変更管理 | E-02 (行97, 272) | ○ |
| C-23 | PullMembersUpOptionsが移動先とメンバー分析結果を保持 | E-03 (行14-39) | ○ |
| C-24 | MemberAndDestinationValidator.IsMemberValidで検証 | E-04 (行29-51) | ○ |
| C-25 | MemberAndDestinationValidator.IsDestinationValidで検証 | E-04 (行14-27) | ○ |
| C-26 | プロパティのgetter/setterで異なるアクセシビリティ対応 | E-02 (行73-80, 170-176) | ○ |
| C-27 | MemberAnalysisResultの詳細構造 | **根拠なし** - ファイル未読込 | △ |
| C-28 | 抽象クラスへの変更条件の詳細 | E-02 (行353-358) - 部分的 | △ |

## 4) 不足情報（Unknown / Missing）
- MemberAnalysisResult.csの詳細構造
  - 候補：該当ファイルの読み込み / ユニットテストコード
- 抽象クラス変更の完全な条件
  - 候補：MembersPuller.csの詳細分析 / 設計ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の基本動作は十分に根拠あり
- 0: 低リスク - インターフェースへの引き上げロジックは明確

## 6) レビュアーチェックリスト（最小）
- [ ] メンバー検証ロジック（有効なメンバー種別）が正しいか
- [ ] インターフェースへの引き上げ時のアクセシビリティ変更が適切か
- [ ] 抽象メンバー引き上げ時のoverride追加が正しいか
- [ ] import文の移動・削除ロジックが漏れなく実装されているか
- [ ] プロパティのgetter/setter個別処理が正しいか
