---
generated_at: 2026-02-10 10:40:00
metrics:
  claims_total: 26
  claims_with_evidence: 24
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：33-メソッドのインライン化

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：24 / 26、根拠なし：2
- 優先レビュー（高）
  1. **MethodParametersInfo構造**：部分ファイルの詳細確認が必要
  2. **型キャスト追加の詳細条件**：実装コードの確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/InlineMethod/AbstractInlineMethodRefactoringProvider.cs`
- E-02: `src/Features/Core/Portable/InlineMethod/AbstractInlineMethodRefactoringProvider.InlineContext.cs`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メソッド呼び出しを本体で直接置換する | E-01, E-03 | ○ |
| C-02 | privateメソッドのみがインライン化対象 | E-01 (行97-98) | ○ |
| C-03 | Ordinaryメソッドまたは拡張メソッドのみ対象 | E-01 (行91) | ○ |
| C-04 | varargメソッドは対象外 | E-01 (行94-95) | ○ |
| C-05 | 単一の宣言を持つメソッドのみ対象 | E-01 (行101) | ○ |
| C-06 | GetRawInlineExpressionでメソッド本体から式を抽出 | E-01 (行61, 107) | ○ |
| C-07 | await式の場合は内部の式を使用 | E-01 (行109-133) | ○ |
| C-08 | throw文/throw式の特殊処理 | E-01 (行138-182) | ○ |
| C-09 | ComputeRenameTableで名前衝突を回避 | E-02 (行350-376) | ○ |
| C-10 | ComputeReplacementTableで置換テーブル生成 | E-02 (行321-348) | ○ |
| C-11 | GetLocalDeclarationStatementsNeedInsertで変数宣言生成 | E-02 (行247-263) | ○ |
| C-12 | ReplaceAllSyntaxNodesForSymbolAsyncでシンボル置換 | E-02 (行284-315) | ○ |
| C-13 | InlineMethodAsyncがメイン処理 | E-01 (行229-289) | ○ |
| C-14 | GetChangedCallerAsyncで呼び出し元変更 | E-01 (行291-331) | ○ |
| C-15 | GetInlineNodeでインライン後ノード決定 | E-01 (行333-478) | ○ |
| C-16 | 再帰呼び出しの場合は削除オプション不可 | E-01 (行211) | ○ |
| C-17 | awaitを含む場合に呼び出し元をasync化 | E-01 (行299-310) | ○ |
| C-18 | SolutionEditorで変更管理 | E-01 (行271) | ○ |
| C-19 | 型キャストと括弧の自動追加 | E-01 (行438-474) | ○ |
| C-20 | throw式からthrow文への変換 | E-01 (行359-373) | ○ |
| C-21 | throw文からthrow式への変換 | E-01 (行415-431) | ○ |
| C-22 | 式文のコンテキストでの変数宣言生成 | E-01 (行375-412) | ○ |
| C-23 | InlineMethodContext構造体の3つの主要情報 | E-02 (行21-40) | ○ |
| C-24 | LocalVariableDeclarationVisitorでローカル変数収集 | E-02 (行378-427) | ○ |
| C-25 | MethodParametersInfo構造の詳細 | **根拠なし** - 部分ファイル未読込 | △ |
| C-26 | 型キャスト追加の詳細条件 | E-01 (行438-474) - 部分的 | △ |

## 4) 不足情報（Unknown / Missing）
- MethodParametersInfo.csの詳細構造
  - 候補：該当部分ファイルの読み込み
- 型キャスト追加の完全な条件
  - 候補：コードの詳細分析 / ユニットテスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の基本動作は十分に根拠あり
- 1: 中リスク - 特殊ケース（throw変換、await処理）の詳細確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] privateメソッド限定の検証が正しいか
- [ ] await式の処理が正しいか
- [ ] throw文/throw式の相互変換が適切か
- [ ] 名前衝突の回避ロジックが正しいか
- [ ] 型キャストの自動追加条件が適切か
- [ ] 再帰呼び出し時の削除オプション無効化が正しいか
