---
generated_at: 2026-02-10 10:50:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：35-パラメータの導入

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **IntroduceParameterDocumentRewriterの詳細実装**：部分ファイル確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/IntroduceParameter/AbstractIntroduceParameterCodeRefactoringProvider.cs`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 式を新しいパラメータとして抽出する | E-01, E-02 | ○ |
| C-02 | IntroduceParameterCodeActionKind列挙型（Refactor/Trampoline/Overload） | E-01 (行36-42) | ○ |
| C-03 | 名前空間/型コンテキスト内の式は対象外 | E-01 (行124-125) | ○ |
| C-04 | メンバーアクセス式の名前部分は対象外 | E-01 (行129) | ○ |
| C-05 | 初期化子の名前部分は対象外 | E-01 (行134) | ○ |
| C-06 | 匿名オブジェクトメンバー宣言子の名前は対象外 | E-01 (行139) | ○ |
| C-07 | 属性引数やパラメータ内は対象外 | E-01 (行145) | ○ |
| C-08 | パラメータリストを持つ先祖ノード検索 | E-01 (行63) | ○ |
| C-09 | Ordinary/LocalFunction/Constructorのみ対象 | E-01 (行89) | ○ |
| C-10 | デストラクタは除外 | E-01 (行92-93) | ○ |
| C-11 | ローカル変数を含む式は対象外 | E-01 (行222-223) | ○ |
| C-12 | レンジ変数を含む式は対象外 | E-01 (行222) | ○ |
| C-13 | paramsパラメータを含む式は対象外 | E-01 (行230-231) | ○ |
| C-14 | this/base参照を含む場合の検出 | E-01 (行238-242) | ○ |
| C-15 | SymbolFinder.FindReferencesAsyncで呼び出し元検索 | E-01 (行289-291) | ○ |
| C-16 | コンストラクタではTrampoline/Overload不可 | E-01 (行174) | ○ |
| C-17 | ローカル関数ではOverload不可 | E-01 (行185) | ○ |
| C-18 | this/base参照時はRefactorのみ | E-01 (行168) | ○ |
| C-19 | オブジェクト生成を含む呼び出し元ではTrampoline不可 | E-01 (行176-177) | ○ |
| C-20 | ProducerConsumer.RunParallelAsyncによる並列処理 | E-01 (行259-276) | ○ |
| C-21 | Solution.WithDocumentSyntaxRootsで変更適用 | E-01 (行278) | ○ |
| C-22 | allOccurrences: true/falseの両方のアクション提供 | E-01 (行101-117) | ○ |
| C-23 | CodeActionPriority.Low設定 | E-01 (行106, 115) | ○ |
| C-24 | ISyntaxFactsServiceでコンテキスト判定 | E-01 (行124, 129, 134, 139, 145) | ○ |
| C-25 | SemanticModel.GetOperationで式内容分析 | E-01 (行238) | ○ |
| C-26 | OperationKind.InstanceReferenceでthis/base検出 | E-01 (行242) | ○ |
| C-27 | IntroduceParameterDocumentRewriter.RewriteDocumentAsyncで書き換え | E-01 (行271) | ○ |
| C-28 | IntroduceParameterDocumentRewriterの詳細動作 | **根拠なし** - 部分ファイル未読込 | △ |

## 4) 不足情報（Unknown / Missing）
- IntroduceParameterDocumentRewriter.csの詳細実装
  - 候補：該当部分ファイルの読み込み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メイン処理は十分に根拠あり
- 0: 低リスク - 式検証ロジックは明確

## 6) レビュアーチェックリスト（最小）
- [ ] 式検証の各条件が正しいか
- [ ] CodeAction種類の決定ロジックが正しいか
- [ ] 並列処理のエラーハンドリングが適切か
- [ ] Trampoline/Overload方式の実装が正しいか（DocumentRewriter確認）
