---
generated_at: 2026-02-10 10:55:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：36-変数の導入

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **State.csの詳細実装**：部分ファイル確認が必要
  2. **CodeAction.csの詳細実装**：部分ファイル確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/IntroduceVariable/AbstractIntroduceVariableService.cs`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 式を新しいローカル変数、定数、またはフィールドとして抽出 | E-01, E-02 | ○ |
| C-02 | State.GenerateAsyncで式の解析と状態生成 | E-01 (行70-72) | ○ |
| C-03 | InQueryContextでクエリ式内判定 | E-01 (行102) | ○ |
| C-04 | InParameterContextでパラメータ初期化子内判定 | E-01 (行109) | ○ |
| C-05 | InFieldContextでフィールド初期化子内判定 | E-01 (行116) | ○ |
| C-06 | InConstructorInitializerContextでコンストラクタ初期化子内判定 | E-01 (行123) | ○ |
| C-07 | InAutoPropertyInitializerContextで自動プロパティ初期化子内判定 | E-01 (行130) | ○ |
| C-08 | InAttributeContextで属性引数内判定 | E-01 (行137) | ○ |
| C-09 | InBlockContextでブロック内判定 | E-01 (行144) | ○ |
| C-10 | InExpressionBodiedMemberContextで式形式メンバー内判定 | E-01 (行163) | ○ |
| C-11 | InGlobalStatementContextでグローバル文内判定 | E-01 (行171) | ○ |
| C-12 | IsConstantで定数判定 | E-01 (行118, 126, 153) | ○ |
| C-13 | クエリ変数として抽出可能 | E-01 (行104-105) | ○ |
| C-14 | allOccurrences true/falseのペアを生成 | E-01 (行104-105, 111-112等) | ○ |
| C-15 | GenerateUniqueFieldNameでフィールド名生成 | E-01 (行257-274) | ○ |
| C-16 | GenerateUniqueLocalNameでローカル変数名生成 | E-01 (行276-291) | ○ |
| C-17 | FindMatchesで同一式検索 | E-01 (行293-311) | ○ |
| C-18 | SemanticEquivalence.AreEquivalentで意味的等価性チェック | E-01 (行333) | ○ |
| C-19 | 静的ローカル関数内の式を全出現置換から除外 | E-01 (行336-339) | ○ |
| C-20 | Rewriteで式を変数参照に置換 | E-01 (行347-366) | ○ |
| C-21 | GetTypeSymbolでFormattableString考慮 | E-01 (行383-386) | ○ |
| C-22 | 隠し領域考慮 | E-01 (行59-60, 151, 155) | ○ |
| C-23 | CanGenerateIntoContainerでコンテナ生成可能判定 | E-01 (行233-252) | ○ |
| C-24 | GetFieldInsertionIndexでフィールド挿入位置決定 | E-01 (行207-231) | ○ |
| C-25 | CodeAction.Createでネストされたアクション生成 | E-01 (行82) | ○ |
| C-26 | SemanticDocument.CreateAsyncでセマンティック情報取得 | E-01 (行70) | ○ |
| C-27 | ComplexifyParentingStatementsAsyncで親ステートメント展開 | E-01 (行419-461) | ○ |
| C-28 | GetAnonymousMethodParametersで匿名メソッドパラメータ取得 | E-01 (行407-417) | ○ |
| C-29 | State.csの詳細構造 | **根拠なし** - 部分ファイル未読込 | △ |
| C-30 | CodeAction.csの詳細実装 | **根拠なし** - 部分ファイル未読込 | △ |

## 4) 不足情報（Unknown / Missing）
- State.csの詳細構造（コンテキスト判定の詳細）
  - 候補：該当部分ファイルの読み込み
- CodeAction.csの詳細実装（IntroduceLocal/IntroduceField）
  - 候補：該当部分ファイルの読み込み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メイン処理は十分に根拠あり
- 0: 低リスク - コンテキスト判定は明確

## 6) レビュアーチェックリスト（最小）
- [ ] 各コンテキスト判定が正しいか
- [ ] 定数判定ロジックが正しいか
- [ ] 同一式の意味的等価性判定が正しいか
- [ ] 静的ローカル関数の除外処理が正しいか
- [ ] FormattableStringの型判定が適切か
