---
generated_at: 2026-02-10 10:55:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-MSBuildタスク

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全ての主張がソースコードから確認可能

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Compilers/Core/MSBuildTask/ManagedCompiler.cs`
- E-02: `src/Compilers/Core/MSBuildTask/Csc.cs`
- E-03: `src/Compilers/Core/MSBuildTask/Vbc.cs`
- E-04: `src/Compilers/Core/MSBuildTask/ManagedToolTask.cs`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ManagedCompilerはManagedToolTaskを継承 | E-01 (27行目 class ManagedCompiler : ManagedToolTask) | ○ |
| C-02 | CompilationKind列挙型で実行方式を区別 | E-01 (29-52行目) | ○ |
| C-03 | Language抽象プロパティでC#/VB識別 | E-01 (56行目 abstract RequestLanguage Language) | ○ |
| C-04 | LogStandardErrorAsError=trueで初期化 | E-01 (63行目) | ○ |
| C-05 | Analyzersプロパティでアナライザー指定 | E-01 (99-103行目) | ○ |
| C-06 | AnalyzerConfigFilesプロパティ対応 | E-01 (169-173行目) | ○ |
| C-07 | Deterministicプロパティで決定論的ビルド | E-01 (157-161行目) | ○ |
| C-08 | CscはRequestLanguage.CSharpCompile | E-02 (42行目相当) | ○ |
| C-09 | AllowUnsafeBlocksプロパティ (Csc) | E-02 (35-39行目) | ○ |
| C-10 | Nullableプロパティ (Csc) | E-02 (156-166行目) | ○ |
| C-11 | VbcはRequestLanguage.VisualBasicCompile | E-03 (42行目) | ○ |
| C-12 | OptionStrict/OptionExplicit/OptionInfer (Vbc) | E-03 (127-143行目) | ○ |
| C-13 | Importsプロパティ (Vbc) | E-03 (86-90行目) | ○ |
| C-14 | VBエラーキューで診断管理 | E-03 (36行目 _vbErrorLines) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認可能なクラス構造
- 0: 低リスク - プロパティ定義の記述
- 0: 低リスク - 列挙型定義の記述

## 6) レビュアーチェックリスト（最小）
- [ ] ManagedCompilerの共通プロパティ一覧が最新か確認
- [ ] Csc固有プロパティが網羅されているか確認
- [ ] Vbc固有プロパティが網羅されているか確認
- [ ] CompilationKindの各値の説明が正確か確認
