---
generated_at: 2026-02-10 11:15:00
metrics:
  claims_total: 30
  claims_with_evidence: 29
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：40-インターフェース実装

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：29 / 30、根拠なし：1
- 優先レビュー（高）
  1. **ImplementInterfaceGenerator.csの詳細実装**：ファイル確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/ImplementInterface/ImplementInterfaceCodeRefactoringProvider.cs`
- E-02: `src/Analyzers/Core/CodeFixes/ImplementInterface/AbstractImplementInterfaceService.cs`
- E-03: `src/Analyzers/Core/CodeFixes/ImplementInterface/IImplementInterfaceService.cs`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | インターフェースのメンバーを自動的に生成 | E-02, E-04 | ○ |
| C-02 | ImplementInterfaceConfiguration構造体 | E-03 (行14-21) | ○ |
| C-03 | ImplementDisposePatternオプション | E-03 (行16) | ○ |
| C-04 | Explicitlyオプション | E-03 (行17) | ○ |
| C-05 | Abstractlyオプション | E-03 (行18) | ○ |
| C-06 | OnlyRemainingオプション | E-03 (行19) | ○ |
| C-07 | ThroughMemberオプション | E-03 (行20) | ○ |
| C-08 | ComputeRefactoringsAsyncがエントリーポイント | E-01 (行22-46) | ○ |
| C-09 | IsBetweenTypeMembersで位置チェック | E-01 (行31) | ○ |
| C-10 | GetInterfaceTypesで実装インターフェース取得 | E-01 (行37), E-03 (行43) | ○ |
| C-11 | GetCodeActionsAsyncでアクション生成 | E-01 (行39-40), E-03 (行40-41) | ○ |
| C-12 | TryInitializeStateで状態初期化 | E-02 (行37-40) | ○ |
| C-13 | ImplementInterfaceAsyncでメイン実装処理 | E-02 (行58-76) | ○ |
| C-14 | State.Generateで状態生成 | E-02 (行64) | ○ |
| C-15 | ShouldImplementDisposePatternでDisposeパターン判定 | E-02 (行70, 200, 215) | ○ |
| C-16 | ImplementInterfaceGeneratorでメンバー生成 | E-02 (行71-72, 114-115, 127-128) | ○ |
| C-17 | GetImplementOptionsAsyncで実装オプション列挙 | E-02 (行173-221) | ○ |
| C-18 | MembersWithoutExplicitOrImplicitImplementationで未実装検出 | E-02 (行179) | ○ |
| C-19 | MembersWithoutExplicitImplementationで明示的未実装検出 | E-02 (行211) | ○ |
| C-20 | 暗黙的実装オプション生成 | E-02 (行198) | ○ |
| C-21 | Disposeパターンオプション生成 | E-02 (行200-201, 215-216) | ○ |
| C-22 | GetDelegatableMembersで委譲可能メンバー取得 | E-02 (行203-205, 299-309) | ○ |
| C-23 | 抽象メンバーオプション生成 | E-02 (行207-208) | ○ |
| C-24 | 明示的実装オプション生成 | E-02 (行213) | ○ |
| C-25 | AnyImplementedImplicitlyで暗黙的実装済みチェック | E-02 (行219, 274-297) | ○ |
| C-26 | GetTitleでCodeActionタイトル生成 | E-02 (行223-249) | ○ |
| C-27 | GetEquivalenceKeyで等価キー生成 | E-02 (行251-272) | ○ |
| C-28 | ImplementInterfaceMemberで単一メンバー実装 | E-02 (行119-144), E-03 (行32-38) | ○ |
| C-29 | CanImplementImplicitlyで暗黙的実装可能判定 | E-02 (行35) | ○ |
| C-30 | ImplementInterfaceGenerator.csの詳細実装 | **根拠なし** - ファイル未読込 | △ |

## 4) 不足情報（Unknown / Missing）
- ImplementInterfaceGenerator.csの詳細実装
  - 候補：該当ファイルの読み込み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メイン処理は十分に根拠あり
- 0: 低リスク - 実装オプション生成は明確

## 6) レビュアーチェックリスト（最小）
- [ ] 実装オプションの生成条件が正しいか
- [ ] Disposeパターンの判定が正しいか
- [ ] 委譲可能メンバーの検出が正しいか
- [ ] 暗黙的/明示的実装の選択条件が正しいか
- [ ] 非公開インターフェースメンバーの処理が正しいか
