---
generated_at: 2026-02-10 13:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：42-Equals/GetHashCode生成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **GetHashCodeアルゴリズム詳細**：64ビット演算のマスク値等の具体的実装要確認
  2. **IEquatable実装詳細**：ref structの判定ロジック要確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/GenerateEqualsAndGetHashCodeFromMembers/GenerateEqualsAndGetHashCodeFromMembersCodeRefactoringProvider.cs`
- E-02: `src/Features/Core/Portable/GenerateEqualsAndGetHashCodeFromMembers/AbstractGenerateEqualsAndGetHashCodeService.cs`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 読み取り可能なインスタンスフィールド/プロパティのみ対象 | E-01 99-103行目 | ○ |
| C-02 | 既存EqualsはIsStatic: falseのメソッドで判定 | E-01 159-161行目 | ○ |
| C-03 | 既存GetHashCodeはパラメータ0のメソッドで判定 | E-01 163-165行目 | ○ |
| C-04 | ref structはIEquatable実装不可 | E-01 140行目 | ○ |
| C-05 | 演算子==と!=の存在をチェック | E-01 123-124行目 | ○ |
| C-06 | 構造体では自動的にIEquatableと演算子を生成 | E-01 300-307行目 | ○ |
| C-07 | System.HashCodeが利用可能な場合は使用 | E-02 151-161行目 | ○ |
| C-08 | HashCodeが使えない場合は従来のハッシュ計算 | E-02 165-166行目 | ○ |
| C-09 | オーバーフロー対策でuncheckedまたは64bit演算 | E-02 171-200行目 | ○ |
| C-10 | タプルが使用可能な場合はタプルのGetHashCodeを使用 | E-02 182-189行目 | ○ |
| C-11 | C#とVisual Basicの両言語をサポート | E-01 30-31行目 | ○ |
| C-12 | 実行順序はGenerateConstructorFromMembersの後 | E-01 32-33行目 | ○ |
| C-13 | MiscellaneousFilesワークスペースでは無効 | E-01 56-59行目 | ○ |
| C-14 | PickMembersOptionでIEquatable実装オプションを提供 | E-01 273-276行目 | ○ |
| C-15 | PickMembersOptionで演算子生成オプションを提供 | E-01 283-286行目 | ○ |
| C-16 | インターフェースでは動作しない | E-01 179行目 | ○ |
| C-17 | 静的クラスでは動作しない | E-01 94-95行目 | ○ |
| C-18 | FormatLargeBinaryExpressionRuleで大きな式をフォーマット | E-02 29行目 | ○ |
| C-19 | GenerateEqualsMethodAsyncでEqualsメソッド生成 | E-02 38-48行目 | ○ |
| C-20 | パフォーマンス要件の具体的数値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値
  - 候補：ベンチマークテスト結果 / パフォーマンスガイドライン

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なロジックはソースコードから確認可能
- 1: 中リスク - GetHashCodeのオーバーフロー対策は言語固有実装があり、VBの場合の動作確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] E-01、E-02のソースコードと設計書の整合性を確認
- [ ] System.HashCodeが利用できない環境での動作確認
- [ ] ref structに対するIEquatable実装の拒否動作確認
- [ ] Visual Basicでの動作確認
