---
generated_at: 2026-02-10 13:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：43-比較演算子生成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. すべての主張に根拠があるため、実装との乖離がないか全体確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/GenerateComparisonOperators/GenerateComparisonOperatorsCodeRefactoringProvider.cs`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 4種類の比較演算子（<、<=、>、>=）を生成 | E-01 28-34行目 | ○ |
| C-02 | 型ヘッダー上またはメンバー間空行で有効 | E-01 52-56行目 | ○ |
| C-03 | IComparable<T>をMetadataNameで取得 | E-01 61行目 | ○ |
| C-04 | エラー型を含む場合は除外 | E-01 76-77行目 | ○ |
| C-05 | CompareTo()メソッドの実装を取得 | E-01 79-81行目、120-128行目 | ○ |
| C-06 | すべての演算子が定義済みの場合はスキップ | E-01 83-84行目 | ○ |
| C-07 | 複数IComparable<T>の場合はサブメニュー | E-01 92-117行目 | ○ |
| C-08 | operator <は left.CompareTo(right) < 0 | E-01 217行目 | ○ |
| C-09 | operator <=は left.CompareTo(right) <= 0 | E-01 218行目 | ○ |
| C-10 | operator >は left.CompareTo(right) > 0 | E-01 219行目 | ○ |
| C-11 | operator >=は left.CompareTo(right) >= 0 | E-01 220行目 | ○ |
| C-12 | 明示的実装の場合はキャストを生成 | E-01 162-169行目 | ○ |
| C-13 | C#とVisual Basicの両言語をサポート | E-01 22行目 | ○ |
| C-14 | HasComparisonOperatorで既存演算子を確認 | E-01 238-252行目 | ○ |
| C-15 | ICodeGenerationService.AddMembersAsyncで挿入 | E-01 153行目 | ○ |
| C-16 | パラメータ名はleftとright | E-01 25-26行目、184-186行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] E-01のソースコードと設計書の整合性を確認
- [ ] 明示的インターフェース実装時のキャスト生成動作確認
- [ ] Visual Basicでの動作確認
