---
generated_at: 2026-02-10 14:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：47-自動プロパティをフルプロパティに変換

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. すべての主張に根拠があるため、実装との乖離がないか全体確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/ConvertAutoPropertyToFullProperty/AbstractConvertAutoPropertyToFullPropertyCodeRefactoringProvider.cs`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TryGetRelevantNodeAsyncでプロパティ宣言取得 | E-01 78行目 | ○ |
| C-02 | SemanticModel.GetDeclaredSymbolでシンボル取得 | E-01 44行目 | ○ |
| C-03 | IsValidAutoPropertyで自動プロパティ検証 | E-01 48行目、69-73行目 | ○ |
| C-04 | AssociatedSymbolがフィールドで判定 | E-01 72行目 | ○ |
| C-05 | Convert to full propertyアクション登録 | E-01 50-54行目 | ○ |
| C-06 | SupportsFieldExpressionでfield式サポート判定 | E-01 58行目 | ○ |
| C-07 | 既存のfield式がない場合のみfield property変換 | E-01 59行目 | ○ |
| C-08 | Convert to field propertyアクション登録 | E-01 61-65行目 | ○ |
| C-09 | GetFieldNameAsyncでフィールド名生成 | E-01 99行目 | ○ |
| C-10 | GetNewAccessorsでgetter/setter生成 | E-01 100行目 | ○ |
| C-11 | GetInitializerValueで初期化子取得 | E-01 111行目 | ○ |
| C-12 | DeclarationModifiers.From(propertySymbol)で修飾子取得 | E-01 109行目 | ○ |
| C-13 | Accessibility.Privateでフィールド生成 | E-01 108行目 | ○ |
| C-14 | TTypeDeclarationNode内のプロパティのみ対象 | E-01 79-80行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] E-01のソースコードと設計書の整合性を確認
- [ ] 言語固有実装（C#/VB）の動作確認
- [ ] field式サポートの動作確認（C# 13以降）
