---
generated_at: 2026-02-10 14:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：50-ifをswitchに変換

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. すべての主張に根拠があるため、実装との乖離がないか全体確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/ConvertIfToSwitch/AbstractConvertIfToSwitchCodeRefactoringProvider.cs`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MiscellaneousFilesワークスペースでは無効 | E-01 37-39行目 | ○ |
| C-02 | TryGetRelevantNodeAsyncでif文取得 | E-01 42行目 | ○ |
| C-03 | ラベル数2つ以上が条件 | E-01 115-118行目 | ○ |
| C-04 | 構文エラーがあると無効 | E-01 83行目 | ○ |
| C-05 | IBlockOperation内が条件 | E-01 89行目 | ○ |
| C-06 | switch文とswitch式のEquivalenceKey | E-01 26-27行目 | ○ |
| C-07 | SyntaxEditorBasedCodeRefactoringProviderを継承 | E-01 24行目 | ○ |
| C-08 | SupportedRefactorAllScopesでFix Allサポート | E-01 32行目 | ○ |
| C-09 | default存在がswitch式の条件 | E-01 128行目 | ○ |
| C-10 | 全セクションがreturn/throwがswitch式の条件 | E-01 132行目 | ○ |
| C-11 | orパターン使用時はガードなし条件 | E-01 177行目 | ○ |
| C-12 | Feature.SwitchExpressionで判定 | E-01 59行目 | ○ |
| C-13 | Feature.OrPatternで判定 | E-01 60行目 | ○ |
| C-14 | AnalyzeIfStatementSequenceでセクション抽出 | E-01 97行目 | ○ |
| C-15 | 外側のifから処理（一括修正） | E-01 206-228行目 | ○ |
| C-16 | TrackNodesで変更追跡 | E-01 200行目 | ○ |
| C-17 | GetSwitchArmKindでreturn/throw判定 | E-01 140-153行目 | ○ |
| C-18 | CanConvertSectionForSwitchExpressionで変換可否判定 | E-01 155-178行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] E-01のソースコードと設計書の整合性を確認
- [ ] Analyzer.csとRewriting.csの詳細実装確認
- [ ] switch式への変換動作確認
- [ ] 一括修正の動作確認
