---
generated_at: 2026-02-10 10:35:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：52-数値リテラル変換

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/ConvertNumericLiteral/AbstractConvertNumericLiteralCodeRefactoringProvider.cs`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 16進数・2進数・10進数の相互変換機能である | E-01 (74-81行目), E-02 (52行目) | ○ |
| C-02 | 桁区切り文字の追加・削除を提供する | E-01 (84-97行目) | ○ |
| C-03 | NumericKind列挙型で形式を管理 | E-01 (23行目) | ○ |
| C-04 | ComputeRequestPriority.Lowで低優先度 | E-01 (31-32行目) | ○ |
| C-05 | 整数型のみ対象（IsIntegralType） | E-01 (52-53行目) | ○ |
| C-06 | 正規表現でプレフィックス・数値・サフィックスを分離 | E-01 (25行目, 131-136行目) | ○ |
| C-07 | 10進数は3桁間隔で桁区切り | E-01 (92行目) | ○ |
| C-08 | 16進数・2進数は4桁間隔で桁区切り | E-01 (93-94行目) | ○ |
| C-09 | サフィックスを保持して変換 | E-01 (112行目, 125-126行目) | ○ |
| C-10 | 単一候補は直接登録、複数はグループ化 | E-01 (99-109行目) | ○ |
| C-11 | SyntaxGenerator.NumericLiteralTokenで新トークン生成 | E-01 (125行目) | ○ |
| C-12 | コンパイル済み正規表現を使用 | E-01 (25行目 RegexOptions.Compiled) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで検証可能

## 6) レビュアーチェックリスト（最小）
- [ ] C#とVBの両方でhexPrefix/binaryPrefixが正しく設定されているか確認
- [ ] 大きな数値（long.MaxValue等）でオーバーフローが発生しないか確認
