---
generated_at: 2026-02-10 10:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：53-文字列補間に変換

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/ConvertToInterpolatedString/AbstractConvertConcatenationToInterpolatedStringRefactoringProvider.cs`
- E-02: `src/Features/Core/Portable/ConvertToInterpolatedString/AbstractConvertPlaceholderToInterpolatedStringRefactoringProvider.cs`
- E-03: `src/Features/Core/Portable/ConvertToInterpolatedString/ConvertRegularStringToInterpolatedStringRefactoringProvider.cs`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 文字列連結を補間文字列に変換する機能 | E-01 (21-24行目コメント), E-04 (53行目) | ○ |
| C-02 | string.Format呼び出しを補間文字列に変換 | E-02 | ○ |
| C-03 | 波括弧を含む通常文字列を補間文字列に変換 | E-03 | ○ |
| C-04 | IsStringConcatで文字列連結を判定 | E-01 (284-297行目) | ○ |
| C-05 | CollectPiecesDownで連結要素を収集 | E-01 (265-282行目) | ○ |
| C-06 | verbatimと通常の混在は変換不可 | E-01 (95-99行目) | ○ |
| C-07 | Raw文字列リテラルは変換対象外 | E-01 (103-104行目) | ○ |
| C-08 | const宣言は変換対象外（定数補間非対応時） | E-01 (51-55行目), E-03 (57-66行目) | ○ |
| C-09 | 波括弧のエスケープ処理 | E-01 (156行目), E-03 (97行目) | ○ |
| C-10 | ToString()の自動削除（ハンドラー対応時） | E-01 (226-253行目) | ○ |
| C-11 | CultureInfoを含む呼び出しは変換対象外 | E-02 (109-114行目) | ○ |
| C-12 | プレースホルダを補間式に置換 | E-02 (404-423行目) | ○ |
| C-13 | 補間文字列がエラーになる場合は変換不可 | E-02 (119-120行目) | ○ |
| C-14 | 低優先度でCodeActionを登録（通常文字列） | E-03 (79行目 CodeActionPriority.Low) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで検証可能

## 6) レビュアーチェックリスト（最小）
- [ ] 複雑なstring.Format（アラインメント、書式指定子付き）が正しく変換されるか確認
- [ ] ネストした補間文字列の連結が適切に処理されるか確認
- [ ] 属性引数内の文字列が正しく除外されるか確認
