---
generated_at: 2026-02-10 10:50:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：55-条件式をステートメントに変換

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/ReplaceConditionalWithStatements/AbstractReplaceConditionalWithStatementsCodeRefactoringProvider.cs`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 条件式をif-elseステートメントに変換する機能 | E-01 (クラス名), E-02 (55行目) | ○ |
| C-02 | ComputeRefactoringsAsyncがエントリーポイント | E-01 (CodeRefactoringProvider継承) | ○ |
| C-03 | 代入式内の条件式を展開可能 | E-01 (SimpleAssignmentExpression処理) | ○ |
| C-04 | return文内の条件式を展開可能 | E-01 (ReturnStatement処理) | ○ |
| C-05 | 変数宣言内の条件式を展開可能 | E-01 (LocalDeclarationStatement処理) | ○ |
| C-06 | GetConditionで条件部分を取得 | E-01 (抽象メソッド) | ○ |
| C-07 | GetWhenTrue/GetWhenFalseで分岐を取得 | E-01 (抽象メソッド) | ○ |
| C-08 | Generator.IfStatementでif-else生成 | E-01 (SyntaxGenerator使用) | ○ |
| C-09 | ステートメントのトップレベルでのみ変換可能 | E-01 (IsValidConditionalチェック) | ○ |
| C-10 | C#とVisual Basicの両方で利用可能 | E-01 (抽象クラス設計) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで検証可能

## 6) レビュアーチェックリスト（最小）
- [ ] C#固有の実装が存在するか確認
- [ ] 式本体メソッド（expression-bodied member）での条件式が適切に処理されるか確認
- [ ] ネストした条件式の再帰処理が正しく動作するか確認
