---
generated_at: 2026-02-10 10:55:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：56-メソッドをプロパティに変換

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/ReplaceMethodWithProperty/ReplaceMethodWithPropertyCodeRefactoringProvider.cs`
- E-02: `src/Features/Core/Portable/ReplaceMethodWithProperty/IReplaceMethodWithPropertyService.cs`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | パラメータなしのゲッターメソッドをプロパティに変換 | E-01 (32-73行目), E-03 (56行目) | ○ |
| C-02 | GetAndSetMethods構造体でペアを管理 | E-02 (29-37行目) | ○ |
| C-03 | IReplaceMethodWithPropertyServiceインターフェース | E-02 (14-27行目) | ○ |
| C-04 | GetMethodDeclarationAsyncでメソッド宣言取得 | E-02 (16行目) | ○ |
| C-05 | パラメータありメソッドは変換不可 | E-01 (パラメータチェック) | ○ |
| C-06 | voidメソッドは変換不可 | E-01 (戻り値チェック) | ○ |
| C-07 | "Get"プレフィックスを除去してプロパティ名生成 | E-01 (GeneratePropertyName) | ○ |
| C-08 | SetXxxメソッドをsetterに統合 | E-01 (FindSetMethod), E-02 (25行目 RemoveSetMethod) | ○ |
| C-09 | SymbolFinderで全参照を検索 | E-01 (SymbolFinder.FindReferencesAsync) | ○ |
| C-10 | SyntaxEditorで参照を更新 | E-02 (18-19行目, 21-24行目) | ○ |
| C-11 | インターフェースメンバー対応 | E-01 (AsInterfaceMember処理) | ○ |
| C-12 | NameGeneratorで名前衝突回避 | E-01 (GenerateUniqueName使用) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで検証可能

## 6) レビュアーチェックリスト（最小）
- [ ] C#固有の実装（CSharpReplaceMethodWithPropertyService）が存在するか確認
- [ ] VB固有の実装（VisualBasicReplaceMethodWithPropertyService）が存在するか確認
- [ ] メタデータからの参照がある場合の警告処理が適切か確認
